/*
 * Decompiled with CFR 0.152.
 */
package iRpc.vote;

import iRpc.dataBridge.vote.DLedgerResponseCode;
import iRpc.vote.DLedgerConfig;
import iRpc.vote.PreConditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberState {
    public static final String TERM_PERSIST_FILE = "currterm";
    public static final String TERM_PERSIST_KEY_TERM = "currTerm";
    public static final String TERM_PERSIST_KEY_VOTE_FOR = "voteLeader";
    public static Logger logger = LoggerFactory.getLogger(MemberState.class);
    public final DLedgerConfig dLedgerConfig;
    private final ReentrantLock defaultLock = new ReentrantLock();
    private final String group;
    private final String selfId;
    private final String peers;
    private Role role = Role.CANDIDATE;
    private String leaderId;
    private long currTerm = -1L;
    private String currVoteFor;
    private long ledgerEndIndex = -1L;
    private long ledgerEndTerm = -1L;
    private long knownMaxTermInGroup = -1L;
    private Map<String, String> peerMap = new HashMap<String, String>();

    public MemberState(DLedgerConfig config) {
        this.group = config.getGroup();
        this.selfId = config.getSelfId();
        this.peers = config.getPeers();
        for (String peerInfo : this.peers.split(";")) {
            this.peerMap.put(peerInfo.split("-")[0], peerInfo.split("-")[1]);
        }
        this.dLedgerConfig = config;
    }

    public long currTerm() {
        return this.currTerm;
    }

    public String currVoteFor() {
        return this.currVoteFor;
    }

    public synchronized void setCurrVoteFor(String currVoteFor) {
        this.currVoteFor = currVoteFor;
    }

    public synchronized long nextTerm() {
        PreConditions.check(this.role == Role.CANDIDATE, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%s != %s", new Object[]{this.role, Role.CANDIDATE});
        this.currTerm = this.knownMaxTermInGroup > this.currTerm ? this.knownMaxTermInGroup : ++this.currTerm;
        this.currVoteFor = null;
        return this.currTerm;
    }

    public synchronized void changeToLeader(long term) {
        PreConditions.check(this.currTerm == term, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%d != %d", this.currTerm, term);
        this.role = Role.LEADER;
        this.leaderId = this.selfId;
    }

    public synchronized void changeToFollower(long term, String leaderId) {
        PreConditions.check(this.currTerm == term, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "%d != %d", this.currTerm, term);
        this.role = Role.FOLLOWER;
        this.leaderId = leaderId;
    }

    public synchronized void changeToCandidate(long term) {
        assert (term >= this.currTerm);
        PreConditions.check(term >= this.currTerm, DLedgerResponseCode.ILLEGAL_MEMBER_STATE, "should %d >= %d", term, this.currTerm);
        if (term > this.knownMaxTermInGroup) {
            this.knownMaxTermInGroup = term;
        }
        this.role = Role.CANDIDATE;
        this.leaderId = null;
    }

    public String getSelfId() {
        return this.selfId;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public String getGroup() {
        return this.group;
    }

    public String getSelfAddr() {
        return this.peerMap.get(this.selfId);
    }

    public String getLeaderAddr() {
        return this.peerMap.get(this.leaderId);
    }

    public String getPeerAddr(String peerId) {
        return this.peerMap.get(peerId);
    }

    public boolean isLeader() {
        return this.role == Role.LEADER;
    }

    public boolean isFollower() {
        return this.role == Role.FOLLOWER;
    }

    public boolean isCandidate() {
        return this.role == Role.CANDIDATE;
    }

    public boolean isQuorum(int num) {
        return num >= this.peerSize() / 2 + 1;
    }

    public int peerSize() {
        return this.peerMap.size();
    }

    public boolean isPeerMember(String id) {
        return id != null && this.peerMap.containsKey(id);
    }

    public Map<String, String> getPeerMap() {
        return this.peerMap;
    }

    public void setCurrTermForTest(long term) {
        PreConditions.check(term >= this.currTerm, DLedgerResponseCode.ILLEGAL_MEMBER_STATE);
        this.currTerm = term;
    }

    public Role getRole() {
        return this.role;
    }

    public ReentrantLock getDefaultLock() {
        return this.defaultLock;
    }

    public void updateLedgerIndexAndTerm(long index, long term) {
        this.ledgerEndIndex = index;
        this.ledgerEndTerm = term;
    }

    public long getLedgerEndIndex() {
        return this.ledgerEndIndex;
    }

    public long getLedgerEndTerm() {
        return this.ledgerEndTerm;
    }

    public static enum Role {
        UNKNOWN,
        CANDIDATE,
        LEADER,
        FOLLOWER;

    }
}

