/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... values) {
        if (values == null || values.length == 0) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> String join(List<T> list, CharSequence delimiter, String prefix, String suffix) {
        if (list == null) {
            return null;
        }
        return list.stream().map(str -> prefix + str + suffix).collect(Collectors.joining(delimiter));
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function) {
        if (CollectionUtils.isEmpty(collection)) {
            return CollectionUtils.newArrayList(new Object[0]);
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

