/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.utils;

import io.github.linpeilie.utils.ArrayUtil;
import java.util.function.Consumer;
import java.util.function.Function;

public class ObjectUtils {
    public static boolean isNull(Object obj) {
        return null == obj || obj.equals(null);
    }

    public static boolean isNotNull(Object obj) {
        return !ObjectUtils.isNull(obj);
    }

    public static <T> boolean isAnyNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T element : array) {
                if (!ObjectUtils.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return !ObjectUtils.isAnyNull(array);
    }

    public static <T> T handleIfNull(T source, Consumer<T> handle) {
        if (ObjectUtils.isAllNotNull(source, handle)) {
            handle.accept(source);
        }
        return source;
    }

    public static <T, R> T defaultIfNull(R source, Function<R, ? extends T> handle, T defaultValue) {
        if (ObjectUtils.isNotNull(source)) {
            return handle.apply(source);
        }
        return defaultValue;
    }

    public static <T, R> T defaultIfNull(R source, Function<R, ? extends T> handle) {
        return ObjectUtils.defaultIfNull(source, handle, null);
    }
}

