/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.builder;

import io.github.pnoker.api.common.GrpcDriverDTO;
import io.github.pnoker.common.driver.entity.bo.DriverBO;
import io.github.pnoker.common.driver.entity.builder.DriverBuilder;
import io.github.pnoker.common.utils.MapStructUtil;
import org.springframework.stereotype.Component;

@Component
public class DriverBuilderImpl
implements DriverBuilder {
    @Override
    public DriverBO buildDTOByGrpcDTO(GrpcDriverDTO entityGrpc) {
        if (entityGrpc == null) {
            return null;
        }
        DriverBO driverBO = new DriverBO();
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getDriverName())) {
            driverBO.setDriverName(entityGrpc.getDriverName());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getDriverCode())) {
            driverBO.setDriverCode(entityGrpc.getDriverCode());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getServiceName())) {
            driverBO.setServiceName(entityGrpc.getServiceName());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getServiceHost())) {
            driverBO.setServiceHost(entityGrpc.getServiceHost());
        }
        if (MapStructUtil.isValidNumber((Number)entityGrpc.getTenantId())) {
            driverBO.setTenantId(entityGrpc.getTenantId());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getSignature())) {
            driverBO.setSignature(entityGrpc.getSignature());
        }
        if (MapStructUtil.isValidNumber((Number)entityGrpc.getVersion())) {
            driverBO.setVersion(entityGrpc.getVersion());
        }
        this.afterProcess(entityGrpc, driverBO);
        return driverBO;
    }

    @Override
    public GrpcDriverDTO buildGrpcDTOByDTO(DriverBO entityDTO) {
        if (entityDTO == null) {
            return null;
        }
        GrpcDriverDTO.Builder grpcDriverDTO = GrpcDriverDTO.newBuilder();
        if (MapStructUtil.isNotEmpty((String)entityDTO.getDriverName())) {
            grpcDriverDTO.setDriverName(entityDTO.getDriverName());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getDriverCode())) {
            grpcDriverDTO.setDriverCode(entityDTO.getDriverCode());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getServiceName())) {
            grpcDriverDTO.setServiceName(entityDTO.getServiceName());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getServiceHost())) {
            grpcDriverDTO.setServiceHost(entityDTO.getServiceHost());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getSignature())) {
            grpcDriverDTO.setSignature(entityDTO.getSignature());
        }
        if (MapStructUtil.isValidNumber((Number)entityDTO.getVersion())) {
            grpcDriverDTO.setVersion(entityDTO.getVersion().intValue());
        }
        if (MapStructUtil.isValidNumber((Number)entityDTO.getTenantId())) {
            grpcDriverDTO.setTenantId(entityDTO.getTenantId().longValue());
        }
        this.afterProcess(entityDTO, grpcDriverDTO);
        return grpcDriverDTO.build();
    }
}

