/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.builder;

import io.github.pnoker.api.common.GrpcDriverAttributeDTO;
import io.github.pnoker.common.driver.entity.builder.GrpcDriverAttributeBuilder;
import io.github.pnoker.common.driver.entity.dto.DriverAttributeDTO;
import io.github.pnoker.common.utils.MapStructUtil;
import org.springframework.stereotype.Component;

@Component
public class GrpcDriverAttributeBuilderImpl
implements GrpcDriverAttributeBuilder {
    @Override
    public DriverAttributeDTO buildDTOByGrpcDTO(GrpcDriverAttributeDTO entityGrpc) {
        if (entityGrpc == null) {
            return null;
        }
        DriverAttributeDTO driverAttributeDTO = new DriverAttributeDTO();
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getDisplayName())) {
            driverAttributeDTO.setDisplayName(entityGrpc.getDisplayName());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getAttributeName())) {
            driverAttributeDTO.setAttributeName(entityGrpc.getAttributeName());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getDefaultValue())) {
            driverAttributeDTO.setDefaultValue(entityGrpc.getDefaultValue());
        }
        if (MapStructUtil.isValidNumber((Number)entityGrpc.getDriverId())) {
            driverAttributeDTO.setDriverId(entityGrpc.getDriverId());
        }
        if (MapStructUtil.isValidNumber((Number)entityGrpc.getTenantId())) {
            driverAttributeDTO.setTenantId(entityGrpc.getTenantId());
        }
        if (MapStructUtil.isNotEmpty((String)entityGrpc.getSignature())) {
            driverAttributeDTO.setSignature(entityGrpc.getSignature());
        }
        if (MapStructUtil.isValidNumber((Number)entityGrpc.getVersion())) {
            driverAttributeDTO.setVersion(entityGrpc.getVersion());
        }
        this.afterProcess(entityGrpc, driverAttributeDTO);
        return driverAttributeDTO;
    }

    @Override
    public GrpcDriverAttributeDTO buildGrpcDTOByDTO(DriverAttributeDTO entityDTO) {
        if (entityDTO == null) {
            return null;
        }
        GrpcDriverAttributeDTO.Builder grpcDriverAttributeDTO = GrpcDriverAttributeDTO.newBuilder();
        if (MapStructUtil.isNotEmpty((String)entityDTO.getDisplayName())) {
            grpcDriverAttributeDTO.setDisplayName(entityDTO.getDisplayName());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getAttributeName())) {
            grpcDriverAttributeDTO.setAttributeName(entityDTO.getAttributeName());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getDefaultValue())) {
            grpcDriverAttributeDTO.setDefaultValue(entityDTO.getDefaultValue());
        }
        if (MapStructUtil.isValidNumber((Number)entityDTO.getDriverId())) {
            grpcDriverAttributeDTO.setDriverId(entityDTO.getDriverId().longValue());
        }
        if (MapStructUtil.isNotEmpty((String)entityDTO.getSignature())) {
            grpcDriverAttributeDTO.setSignature(entityDTO.getSignature());
        }
        if (MapStructUtil.isValidNumber((Number)entityDTO.getVersion())) {
            grpcDriverAttributeDTO.setVersion(entityDTO.getVersion().intValue());
        }
        if (MapStructUtil.isValidNumber((Number)entityDTO.getTenantId())) {
            grpcDriverAttributeDTO.setTenantId(entityDTO.getTenantId().longValue());
        }
        this.afterProcess(entityDTO, grpcDriverAttributeDTO);
        return grpcDriverAttributeDTO.build();
    }
}

