/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.event.metadata;

import io.github.pnoker.common.driver.service.DriverCustomService;
import io.github.pnoker.common.entity.dto.MetadataEventDTO;
import io.github.pnoker.common.entity.event.MetadataEvent;
import io.github.pnoker.common.enums.MetadataTypeEnum;
import io.github.pnoker.common.utils.JsonUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MetadataEventListener
implements ApplicationListener<MetadataEvent> {
    private static final Logger log = LoggerFactory.getLogger(MetadataEventListener.class);
    private final DriverCustomService driverCustomService;

    public MetadataEventListener(DriverCustomService driverCustomService) {
        this.driverCustomService = driverCustomService;
    }

    public void onApplicationEvent(@NotNull MetadataEvent metadataEvent) {
        log.info("Metadata event listener received: {}", (Object)JsonUtil.toJsonString((Object)metadataEvent));
        MetadataTypeEnum metadataType = metadataEvent.getMetadataType();
        if (MetadataTypeEnum.DEVICE.equals((Object)metadataType)) {
            MetadataEventDTO entityEvent = new MetadataEventDTO();
            entityEvent.setId(metadataEvent.getId());
            entityEvent.setMetadataType(MetadataTypeEnum.DEVICE);
            entityEvent.setOperateType(metadataEvent.getOperateType());
            this.driverCustomService.event(entityEvent);
        } else if (MetadataTypeEnum.POINT.equals((Object)metadataType)) {
            MetadataEventDTO entityEvent = new MetadataEventDTO();
            entityEvent.setId(metadataEvent.getId());
            entityEvent.setMetadataType(MetadataTypeEnum.POINT);
            entityEvent.setOperateType(metadataEvent.getOperateType());
            this.driverCustomService.event(entityEvent);
        }
    }
}

