/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.grpc.client;

import io.github.pnoker.api.common.GrpcDriverAttributeConfigDTO;
import io.github.pnoker.api.common.GrpcPage;
import io.github.pnoker.api.common.GrpcPointAttributeConfigDTO;
import io.github.pnoker.api.common.driver.DeviceApiGrpc;
import io.github.pnoker.api.common.driver.GrpcDeviceQuery;
import io.github.pnoker.api.common.driver.GrpcPageDeviceDTO;
import io.github.pnoker.api.common.driver.GrpcPageDeviceQuery;
import io.github.pnoker.api.common.driver.GrpcRDeviceAttachDTO;
import io.github.pnoker.api.common.driver.GrpcRDeviceDTO;
import io.github.pnoker.api.common.driver.GrpcRPageDeviceDTO;
import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.entity.builder.DeviceBuilder;
import io.github.pnoker.common.driver.entity.builder.GrpcDriverAttributeConfigBuilder;
import io.github.pnoker.common.driver.entity.builder.GrpcPointAttributeConfigBuilder;
import io.github.pnoker.common.driver.entity.dto.DriverAttributeConfigDTO;
import io.github.pnoker.common.driver.entity.dto.PointAttributeConfigDTO;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.exception.ServiceException;
import io.github.pnoker.common.optional.CollectionOptional;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeviceClient {
    private static final Logger log = LoggerFactory.getLogger(DeviceClient.class);
    @GrpcClient(value="dc3-center-manager")
    private DeviceApiGrpc.DeviceApiBlockingStub deviceApiBlockingStub;
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DeviceBuilder deviceBuilder;
    @Resource
    private GrpcDriverAttributeConfigBuilder grpcDriverAttributeConfigBuilder;
    @Resource
    private GrpcPointAttributeConfigBuilder grpcPointAttributeConfigBuilder;

    public List<DeviceBO> list() {
        long current = 1L;
        GrpcRPageDeviceDTO rPageDeviceDTO = this.getGrpcRPageDeviceDTO(current);
        GrpcPageDeviceDTO pageDTO = rPageDeviceDTO.getData();
        List dataList = pageDTO.getDataList();
        List<DeviceBO> deviceBOList = dataList.stream().map(this::buildDTOByGrpcAttachDTO).toList();
        ArrayList<DeviceBO> allDeviceBOList = new ArrayList<DeviceBO>(deviceBOList);
        long pages = pageDTO.getPage().getPages();
        while (current < pages) {
            GrpcRPageDeviceDTO tPageDeviceDTO = this.getGrpcRPageDeviceDTO(++current);
            GrpcPageDeviceDTO tPageDTO = tPageDeviceDTO.getData();
            List tDataList = tPageDTO.getDataList();
            List<DeviceBO> tDeviceBOList = tDataList.stream().map(this::buildDTOByGrpcAttachDTO).toList();
            allDeviceBOList.addAll(tDeviceBOList);
            pages = tPageDTO.getPage().getPages();
        }
        return allDeviceBOList;
    }

    public DeviceBO selectById(Long id) {
        GrpcDeviceQuery.Builder query = GrpcDeviceQuery.newBuilder();
        query.setDeviceId(id.longValue());
        GrpcRDeviceDTO rDeviceDTO = this.deviceApiBlockingStub.selectById(query.build());
        if (!rDeviceDTO.getResult().getOk()) {
            log.error("Device doesn't exist: {}", (Object)id);
            return null;
        }
        GrpcRDeviceAttachDTO rDeviceAttachDTO = rDeviceDTO.getData();
        return this.buildDTOByGrpcAttachDTO(rDeviceAttachDTO);
    }

    private GrpcRPageDeviceDTO getGrpcRPageDeviceDTO(long current) {
        GrpcPageDeviceQuery.Builder query = GrpcPageDeviceQuery.newBuilder();
        GrpcPage.Builder page = GrpcPage.newBuilder();
        page.setCurrent(current);
        query.setTenantId(this.driverMetadata.getDriver().getTenantId().longValue()).setDriverId(this.driverMetadata.getDriver().getId().longValue()).setPage(page);
        GrpcRPageDeviceDTO rPageDeviceDTO = this.deviceApiBlockingStub.selectByPage(query.build());
        if (!rPageDeviceDTO.getResult().getOk()) {
            throw new ServiceException((CharSequence)"\u83b7\u53d6\u8bbe\u5907\u5217\u8868\u5931\u8d25", new Object[0]);
        }
        return rPageDeviceDTO;
    }

    private DeviceBO buildDTOByGrpcAttachDTO(GrpcRDeviceAttachDTO rDeviceAttachDTO) {
        DeviceBO deviceBO = this.deviceBuilder.buildDTOByGrpcDTO(rDeviceAttachDTO.getDevice());
        deviceBO.setPointIds(new HashSet<Long>(rDeviceAttachDTO.getPointIdsList()));
        CollectionOptional.ofNullable((Collection)rDeviceAttachDTO.getDriverConfigsList()).ifPresent(value -> {
            Map<Long, DriverAttributeConfigDTO> driverAttributeConfigMap = value.stream().collect(Collectors.toMap(GrpcDriverAttributeConfigDTO::getDriverAttributeId, this.grpcDriverAttributeConfigBuilder::buildDTOByGrpcDTO));
            deviceBO.setDriverAttributeConfigIdMap(driverAttributeConfigMap);
        });
        CollectionOptional.ofNullable((Collection)rDeviceAttachDTO.getPointConfigsList()).ifPresent(value -> {
            Map<Long, Map<Long, PointAttributeConfigDTO>> pointAttributeConfigMap = value.stream().collect(Collectors.groupingBy(GrpcPointAttributeConfigDTO::getPointId, Collectors.toMap(GrpcPointAttributeConfigDTO::getPointAttributeId, this.grpcPointAttributeConfigBuilder::buildDTOByGrpcDTO)));
            deviceBO.setPointAttributeConfigIdMap(pointAttributeConfigMap);
        });
        return deviceBO;
    }
}

