/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.grpc.client;

import io.github.pnoker.api.common.GrpcDriverAttributeDTO;
import io.github.pnoker.api.common.GrpcDriverDTO;
import io.github.pnoker.api.common.GrpcPointAttributeDTO;
import io.github.pnoker.api.common.driver.DriverApiGrpc;
import io.github.pnoker.api.common.driver.GrpcDriverRegisterDTO;
import io.github.pnoker.api.common.driver.GrpcRDriverRegisterDTO;
import io.github.pnoker.common.driver.entity.bo.DriverBO;
import io.github.pnoker.common.driver.entity.bo.RegisterBO;
import io.github.pnoker.common.driver.entity.builder.DriverBuilder;
import io.github.pnoker.common.driver.entity.builder.GrpcDriverAttributeBuilder;
import io.github.pnoker.common.driver.entity.builder.GrpcPointAttributeBuilder;
import io.github.pnoker.common.driver.entity.dto.DriverAttributeDTO;
import io.github.pnoker.common.driver.entity.dto.PointAttributeDTO;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.enums.DriverStatusEnum;
import io.github.pnoker.common.exception.RegisterException;
import io.github.pnoker.common.optional.CollectionOptional;
import jakarta.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DriverClient {
    private static final Logger log = LoggerFactory.getLogger(DriverClient.class);
    @GrpcClient(value="dc3-center-manager")
    private DriverApiGrpc.DriverApiBlockingStub driverApiBlockingStub;
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DriverBuilder driverBuilder;
    @Resource
    private GrpcDriverAttributeBuilder grpcDriverAttributeBuilder;
    @Resource
    private GrpcPointAttributeBuilder grpcPointAttributeBuilder;

    public void driverRegister(RegisterBO entityBO) {
        GrpcDriverRegisterDTO.Builder builder = GrpcDriverRegisterDTO.newBuilder();
        GrpcDriverDTO grpcDriverDTO = this.driverBuilder.buildGrpcDTOByDTO(entityBO.getDriver());
        builder.setTenant(entityBO.getTenant()).setClient(entityBO.getClient()).setDriver(grpcDriverDTO);
        CollectionOptional.ofNullable(entityBO.getDriverAttributes()).ifPresent(value -> {
            List<GrpcDriverAttributeDTO> grpcDriverAttributeDTOList = value.stream().map(this.grpcDriverAttributeBuilder::buildGrpcDTOByDTO).toList();
            builder.addAllDriverAttributes(grpcDriverAttributeDTOList);
        });
        CollectionOptional.ofNullable(entityBO.getPointAttributes()).ifPresent(value -> {
            List<GrpcPointAttributeDTO> grpcPointAttributeDTOList = value.stream().map(this.grpcPointAttributeBuilder::buildGrpcDTOByDTO).toList();
            builder.addAllPointAttributes(grpcPointAttributeDTOList);
        });
        GrpcRDriverRegisterDTO rDriverRegisterDTO = this.driverApiBlockingStub.driverRegister(builder.build());
        if (!rDriverRegisterDTO.getResult().getOk()) {
            throw new RegisterException((CharSequence)rDriverRegisterDTO.getResult().getMessage(), new Object[0]);
        }
        DriverBO driverBO = this.driverBuilder.buildDTOByGrpcDTO(rDriverRegisterDTO.getDriver());
        this.driverMetadata.setDriver(driverBO);
        this.driverMetadata.setDeviceIds(new HashSet<Long>(rDriverRegisterDTO.getDeviceIdsList()));
        List driverAttributesList = rDriverRegisterDTO.getDriverAttributesList();
        Map<Long, DriverAttributeDTO> driverAttributeIdMap = driverAttributesList.stream().collect(Collectors.toMap(entity -> entity.getBase().getId(), this.grpcDriverAttributeBuilder::buildDTOByGrpcDTO));
        Map<String, DriverAttributeDTO> driverAttributeNameMap = driverAttributesList.stream().collect(Collectors.toMap(GrpcDriverAttributeDTO::getAttributeName, this.grpcDriverAttributeBuilder::buildDTOByGrpcDTO));
        this.driverMetadata.setDriverAttributeIdMap(driverAttributeIdMap);
        this.driverMetadata.setDriverAttributeNameMap(driverAttributeNameMap);
        List pointAttributesList = rDriverRegisterDTO.getPointAttributesList();
        Map<Long, PointAttributeDTO> pointAttributeIdMap = pointAttributesList.stream().collect(Collectors.toMap(entity -> entity.getBase().getId(), this.grpcPointAttributeBuilder::buildDTOByGrpcDTO));
        Map<String, PointAttributeDTO> pointAttributeNameMap = pointAttributesList.stream().collect(Collectors.toMap(GrpcPointAttributeDTO::getAttributeName, this.grpcPointAttributeBuilder::buildDTOByGrpcDTO));
        this.driverMetadata.setPointAttributeIdMap(pointAttributeIdMap);
        this.driverMetadata.setPointAttributeNameMap(pointAttributeNameMap);
        this.driverMetadata.setDriverStatus(DriverStatusEnum.ONLINE);
    }
}

