/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.grpc.client;

import io.github.pnoker.api.common.GrpcPage;
import io.github.pnoker.api.common.driver.GrpcPagePointDTO;
import io.github.pnoker.api.common.driver.GrpcPagePointQuery;
import io.github.pnoker.api.common.driver.GrpcPointQuery;
import io.github.pnoker.api.common.driver.GrpcRPagePointDTO;
import io.github.pnoker.api.common.driver.GrpcRPointDTO;
import io.github.pnoker.api.common.driver.PointApiGrpc;
import io.github.pnoker.common.driver.entity.bo.PointBO;
import io.github.pnoker.common.driver.entity.builder.PointBuilder;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.exception.ServiceException;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PointClient {
    private static final Logger log = LoggerFactory.getLogger(PointClient.class);
    @GrpcClient(value="dc3-center-manager")
    private PointApiGrpc.PointApiBlockingStub pointApiBlockingStub;
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private PointBuilder pointBuilder;

    public List<PointBO> list() {
        long current = 1L;
        GrpcRPagePointDTO rPagePointDTO = this.getGrpcRPagePointDTO(current);
        GrpcPagePointDTO pageDTO = rPagePointDTO.getData();
        List dataList = pageDTO.getDataList();
        List<PointBO> pointBOList = dataList.stream().map(this.pointBuilder::buildDTOByGrpcDTO).toList();
        ArrayList<PointBO> allPointBOList = new ArrayList<PointBO>(pointBOList);
        long pages = pageDTO.getPage().getPages();
        while (current < pages) {
            GrpcRPagePointDTO tPagePointDTO = this.getGrpcRPagePointDTO(++current);
            GrpcPagePointDTO tPageDTO = tPagePointDTO.getData();
            List tDataList = tPageDTO.getDataList();
            List<PointBO> tPointBOList = tDataList.stream().map(this.pointBuilder::buildDTOByGrpcDTO).toList();
            allPointBOList.addAll(tPointBOList);
            pages = tPageDTO.getPage().getPages();
        }
        return allPointBOList;
    }

    public PointBO selectById(Long id) {
        GrpcPointQuery.Builder query = GrpcPointQuery.newBuilder();
        query.setPointId(id.longValue());
        GrpcRPointDTO rPointDTO = this.pointApiBlockingStub.selectById(query.build());
        if (!rPointDTO.getResult().getOk()) {
            log.error("Point doesn't exist: {}", (Object)id);
            return null;
        }
        return this.pointBuilder.buildDTOByGrpcDTO(rPointDTO.getData());
    }

    private GrpcRPagePointDTO getGrpcRPagePointDTO(long current) {
        GrpcPagePointQuery.Builder query = GrpcPagePointQuery.newBuilder();
        GrpcPage.Builder page = GrpcPage.newBuilder();
        page.setCurrent(current);
        query.setTenantId(this.driverMetadata.getDriver().getTenantId().longValue()).setDriverId(this.driverMetadata.getDriver().getId().longValue()).setPage(page);
        GrpcRPagePointDTO rPagePointDTO = this.pointApiBlockingStub.selectByPage(query.build());
        if (!rPagePointDTO.getResult().getOk()) {
            throw new ServiceException((CharSequence)"\u83b7\u53d6\u8bbe\u5907\u5217\u8868\u5931\u8d25", new Object[0]);
        }
        return rPagePointDTO;
    }
}

