/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.metadata;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.pnoker.common.driver.entity.bo.PointBO;
import io.github.pnoker.common.driver.grpc.client.PointClient;
import io.github.pnoker.common.utils.JsonUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class PointMetadata {
    private static final Logger log = LoggerFactory.getLogger(PointMetadata.class);
    private final AsyncLoadingCache<Long, PointBO> cache;
    private final PointClient pointClient;

    public PointMetadata(PointClient pointClient) {
        this.pointClient = pointClient;
        this.cache = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(24L, TimeUnit.HOURS).removalListener((key, value, cause) -> log.info("Remove key={}, value={} cache, reason is: {}", new Object[]{key, value, cause})).buildAsync((key, executor) -> CompletableFuture.supplyAsync(() -> {
            log.info("Load point metadata by id: {}", key);
            PointBO pointBO = this.pointClient.selectById((Long)key);
            log.info("Cache point metadata: {}", (Object)JsonUtil.toJsonString((Object)((Object)pointBO)));
            return pointBO;
        }, executor));
    }

    public PointBO getCache(long id) {
        try {
            CompletableFuture future = this.cache.get((Object)id);
            return (PointBO)((Object)future.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get the point cache: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void loadCache(long id) {
        CompletableFuture<PointBO> future = CompletableFuture.supplyAsync(() -> this.pointClient.selectById(id));
        this.cache.put((Object)id, future);
    }

    public void removeCache(long id) {
        this.cache.put((Object)id, CompletableFuture.completedFuture(null));
    }
}

