/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.annotation;

import io.github.pnoker.common.annotation.Logs;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogsAspect {
    private static final Logger log = LoggerFactory.getLogger(LogsAspect.class);

    @Pointcut(value="@annotation(io.github.pnoker.common.annotation.Logs)")
    public void logsCut() {
    }

    @Around(value="logsCut() && @annotation(logs)")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint, Logs logs) throws Throwable {
        String uuid = UUID.randomUUID().toString();
        String className = proceedingJoinPoint.getSignature().getDeclaringType().getSimpleName();
        String methodName = proceedingJoinPoint.getSignature().getName();
        long startTime = System.currentTimeMillis();
        log.info("Start => [{}].[{}.{}]: {}", new Object[]{uuid, className, methodName, logs.value()});
        try {
            Object proceed = proceedingJoinPoint.proceed();
            log.info("End   <= [{}].[{}.{}].[{}ms]: {}", new Object[]{uuid, className, methodName, System.currentTimeMillis() - startTime, logs.value()});
            return proceed;
        }
        catch (Throwable throwable) {
            log.info("End   <= [{}].[{}.{}].[{}ms]: {}", new Object[]{uuid, className, methodName, System.currentTimeMillis() - startTime, logs.value()});
            throw throwable;
        }
    }
}

