/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.pnoker.common.enums.ResponseEnum;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean ok = false;
    private String code = ResponseEnum.OK.getCode();
    private String message = ResponseEnum.OK.getText();
    private T data;

    private R() {
    }

    private R(T data) {
        this.data = data;
    }

    public static <T> R<T> ok() {
        return new R<T>().success();
    }

    public static <T> R<T> ok(String message) {
        return new R<T>().success(message);
    }

    public static <T> R<T> ok(ResponseEnum code) {
        return new R<T>().success(code.getCode(), code.getText());
    }

    public static <T> R<T> ok(ResponseEnum code, String message) {
        return new R<T>().success(code.getCode(), message);
    }

    public static <T> R<T> ok(T data) {
        return new R<T>(data).success();
    }

    public static <T> R<T> ok(T data, String message) {
        return new R<T>(data).success(message);
    }

    public static <T> R<T> fail() {
        return new R<T>().failure();
    }

    public static <T> R<T> fail(String message) {
        return new R<T>().failure(message);
    }

    public static <T> R<T> fail(ResponseEnum code) {
        return new R<T>().failure(code.getCode(), code.getText());
    }

    public static <T> R<T> fail(ResponseEnum code, String message) {
        return new R<T>().failure(code.getCode(), message);
    }

    public static <T> R<T> fail(T data) {
        return new R<T>(data).failure();
    }

    public static <T> R<T> fail(T data, String message) {
        return new R<T>(data).failure(message);
    }

    private R<T> success() {
        this.ok = true;
        this.code = ResponseEnum.OK.getCode();
        this.message = ResponseEnum.OK.getText();
        return this;
    }

    private R<T> success(String message) {
        this.ok = true;
        this.code = ResponseEnum.OK.getCode();
        this.message = message;
        return this;
    }

    private R<T> success(String code, String message) {
        this.ok = true;
        this.code = code;
        this.message = message;
        return this;
    }

    private R<T> failure() {
        this.ok = false;
        this.code = ResponseEnum.FAILURE.getCode();
        this.message = ResponseEnum.FAILURE.getText();
        return this;
    }

    private R<T> failure(String message) {
        this.ok = false;
        this.code = ResponseEnum.FAILURE.getCode();
        this.message = message;
        return this;
    }

    private R<T> failure(String code, String message) {
        this.ok = false;
        this.code = code;
        this.message = message;
        return this;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }
}

