/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.optional;

import io.github.pnoker.common.constant.common.DefaultConstant;
import java.util.Objects;
import java.util.function.IntConsumer;

public final class IntegerOptional {
    private final Integer value;

    private IntegerOptional(Integer value) {
        this.value = value;
    }

    public static IntegerOptional ofNullable(Integer value) {
        return new IntegerOptional(value);
    }

    public void ifPresent(IntConsumer action) {
        if (Objects.nonNull(this.value) && this.value > DefaultConstant.ZERO) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(IntConsumer action, Runnable emptyAction) {
        if (this.value > DefaultConstant.ZERO) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }
}

