/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostUtil {
    private static final Logger log = LoggerFactory.getLogger(HostUtil.class);

    private HostUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String localHost() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Set<String> getHostNames(String address) {
        return HostUtil.getHostNames(address, true);
    }

    public static Set<String> getHostNames(String address, boolean includeLoopBack) {
        HashSet<String> hostNames = new HashSet<String>(4);
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress.isAnyLocalAddress()) {
                HostUtil.loopBackAddresses(hostNames, includeLoopBack);
            } else {
                boolean loopback = inetAddress.isLoopbackAddress();
                if (!loopback || includeLoopBack) {
                    hostNames.add(inetAddress.getHostName());
                    hostNames.add(inetAddress.getHostAddress());
                    hostNames.add(inetAddress.getCanonicalHostName());
                }
            }
        }
        catch (SocketException | UnknownHostException e) {
            log.warn("Failed to get hostname for bind address: {}", (Object)address, (Object)e);
        }
        return hostNames;
    }

    public static List<String> localMacList() {
        ArrayList<String> macList = new ArrayList<String>(16);
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                HostUtil.lookupLocalMac(macList, networkInterface);
            }
            if (!macList.isEmpty()) {
                return macList.stream().distinct().toList();
            }
        }
        catch (Exception e) {
            log.warn("Failed to get local mac address");
        }
        return macList;
    }

    private static void loopBackAddresses(Set<String> hostNames, boolean includeLoopBack) throws SocketException {
        Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface networkInterface : Collections.list(interfaceEnumeration)) {
            Collections.list(networkInterface.getInetAddresses()).forEach(inetAddress -> {
                boolean loopback;
                if (inetAddress instanceof Inet4Address && (!(loopback = inetAddress.isLoopbackAddress()) || includeLoopBack)) {
                    hostNames.add(inetAddress.getHostName());
                    hostNames.add(inetAddress.getHostAddress());
                    hostNames.add(inetAddress.getCanonicalHostName());
                }
            });
        }
    }

    private static void lookupLocalMac(ArrayList<String> macList, NetworkInterface networkInterface) throws SocketException {
        List<InterfaceAddress> interfaceAddressList = networkInterface.getInterfaceAddresses();
        for (InterfaceAddress interfaceAddress : interfaceAddressList) {
            byte[] mac;
            InetAddress inetAddress = interfaceAddress.getAddress();
            NetworkInterface network = NetworkInterface.getByInetAddress(inetAddress);
            if (network == null || (mac = network.getHardwareAddress()) == null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                stringBuilder.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            macList.add(stringBuilder.toString());
        }
    }
}

