/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.github.pnoker.common.exception.JsonException;
import io.github.pnoker.common.utils.DecodeUtil;
import io.github.pnoker.common.utils.LocalDateTimeUtil;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public final class JsonUtil {
    private static final JsonMapper JSON_MAPPER = JsonUtil.getJsonMapper();

    private JsonUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static JsonMapper getJsonMapper() {
        LocalDateTimeSerializer serializer = new LocalDateTimeSerializer(LocalDateTimeUtil.getCompleteDateTimeFormatter());
        LocalDateTimeDeserializer deserializer = new LocalDateTimeDeserializer(LocalDateTimeUtil.getCompleteDateTimeFormatter());
        JavaTimeModule module = new JavaTimeModule();
        module.addSerializer(LocalDateTime.class, (JsonSerializer)serializer);
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)deserializer);
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule((Module)module)).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, Boolean.FALSE.booleanValue())).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, Boolean.TRUE.booleanValue())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue())).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, Boolean.FALSE.booleanValue())).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    }

    public static <T> T parseObject(String text, Class<T> valueType) {
        try {
            if (CharSequenceUtil.isEmpty((CharSequence)text)) {
                return null;
            }
            return (T)JSON_MAPPER.readValue(text, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(bytes, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(JsonParser jsonParser, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(jsonParser, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(DataInput dataInput, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(dataInput, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(InputStream inputStream, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(inputStream, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(Reader reader, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(reader, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(File file, Class<T> valueType) {
        try {
            return (T)JSON_MAPPER.readValue(file, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        try {
            return (T)JSON_MAPPER.readValue(text, typeReference);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(text, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(bytes, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(JsonParser jsonParser, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(jsonParser, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(DataInput dataInput, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(dataInput, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(InputStream inputStream, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(inputStream, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(Reader reader, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(reader, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(File file, Class<T> valueType) {
        try {
            JavaType javaType = JSON_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)JSON_MAPPER.readValue(file, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toJsonString(T type) {
        try {
            return JSON_MAPPER.writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toJsonString(T type, Class<?> serializationView) {
        try {
            return JSON_MAPPER.writerWithView(serializationView).writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toPrettyJsonString(T type) {
        try {
            return JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toPrettyJsonString(T type, Class<?> serializationView) {
        try {
            return JSON_MAPPER.writerWithView(serializationView).withDefaultPrettyPrinter().writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> byte[] toJsonBytes(T type) {
        try {
            return DecodeUtil.stringToByte(JSON_MAPPER.writeValueAsString(type));
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }
}

