/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.github.pnoker.common.constant.common.DefaultConstant;
import io.github.pnoker.common.entity.common.Pages;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUtil {
    private static final Logger log = LoggerFactory.getLogger(PageUtil.class);

    private PageUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Page<T> page(Pages pages) {
        Page page = new Page();
        if (Objects.isNull(pages)) {
            pages = new Pages();
        }
        if (pages.getCurrent() < (long)DefaultConstant.ONE.intValue()) {
            pages.setCurrent(DefaultConstant.ONE.intValue());
        }
        page.setCurrent(pages.getCurrent());
        if (pages.getSize() > (long)DefaultConstant.MAX_PAGE_SIZE.intValue()) {
            pages.setSize(DefaultConstant.MAX_PAGE_SIZE.intValue());
        }
        page.setSize(pages.getSize());
        List<OrderItem> orders = pages.getOrders();
        boolean anyMatch = orders.stream().filter(order -> Objects.nonNull(order) && CharSequenceUtil.isNotEmpty((CharSequence)order.getColumn())).anyMatch(order -> "create_time".equals(order.getColumn()));
        if (!anyMatch) {
            orders.add(OrderItem.desc((String)"create_time"));
        }
        List<OrderItem> orderItemList = orders.stream().filter(order -> Objects.nonNull(order) && CharSequenceUtil.isNotEmpty((CharSequence)order.getColumn())).toList();
        page.setOrders(orderItemList);
        return page;
    }
}

