/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeUtil.class);
    private static final ThreadLocal<SimpleDateFormat> DEFAULT_DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocal<SimpleDateFormat> COMPLETE_DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));

    private TimeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static long milliSeconds(Date date) {
        return date.getTime();
    }

    public static Date localDateTime(long milliSeconds) {
        return new Date(milliSeconds);
    }

    public static Date expireTime(int amount, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static String defaultFormat(Date date) {
        return DEFAULT_DATE_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static String completeFormat(Date date) {
        return COMPLETE_DATE_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static Date defaultDate(String dateString) {
        try {
            return DEFAULT_DATE_FORMAT_THREAD_LOCAL.get().parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date completeDate(String dateString) {
        try {
            return COMPLETE_DATE_FORMAT_THREAD_LOCAL.get().parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void clean() {
        DEFAULT_DATE_FORMAT_THREAD_LOCAL.remove();
        COMPLETE_DATE_FORMAT_THREAD_LOCAL.remove();
    }
}

