/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.thread.threadlocal.NamedThreadLocal;
import io.github.pnoker.common.entity.common.RequestHeader;
import io.github.pnoker.common.exception.UnAuthorizedException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(UserHeaderUtil.class);
    private static final ThreadLocal<RequestHeader.UserHeader> USER_HEADER_THREAD_LOCAL = new NamedThreadLocal("Request of user header");

    private UserHeaderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static RequestHeader.UserHeader getUserHeader() {
        RequestHeader.UserHeader entityBO = USER_HEADER_THREAD_LOCAL.get();
        if (Objects.isNull(entityBO)) {
            throw new UnAuthorizedException((CharSequence)"Unable to get user header", new Object[0]);
        }
        return entityBO;
    }

    public static void setUserHeader(RequestHeader.UserHeader entityBO) {
        if (Objects.isNull(entityBO) || Objects.isNull(entityBO.getTenantId()) || Objects.isNull(entityBO.getUserId())) {
            UserHeaderUtil.removeUserHeader();
        } else {
            USER_HEADER_THREAD_LOCAL.set(entityBO);
        }
    }

    public static Long getTenantId() {
        RequestHeader.UserHeader entityBO = UserHeaderUtil.getUserHeader();
        Long tenantId = entityBO.getTenantId();
        if (Objects.isNull(tenantId)) {
            throw new UnAuthorizedException((CharSequence)"Unable to get tenant id of user header", new Object[0]);
        }
        return tenantId;
    }

    public static Long getUserId() {
        RequestHeader.UserHeader entityBO = UserHeaderUtil.getUserHeader();
        Long userId = entityBO.getUserId();
        if (Objects.isNull(userId)) {
            throw new UnAuthorizedException((CharSequence)"Unable to get user id of user header", new Object[0]);
        }
        return userId;
    }

    public static void removeUserHeader() {
        USER_HEADER_THREAD_LOCAL.remove();
    }
}

