/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common;

import io.github.resilience4j.common.CustomizerWithName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CompositeCustomizer<T extends CustomizerWithName> {
    private final Map<String, T> customizerMap = new HashMap<String, T>();

    public CompositeCustomizer(List<T> customizers) {
        if (customizers != null && !customizers.isEmpty()) {
            customizers.forEach(customizer -> {
                if (this.customizerMap.containsKey(customizer.name())) {
                    throw new IllegalStateException("It is not possible to define more than one customizer per instance name " + customizer.name());
                }
                this.customizerMap.put(customizer.name(), customizer);
            });
        }
    }

    public Optional<T> getCustomizer(String instanceName) {
        return Optional.ofNullable((CustomizerWithName)this.customizerMap.get(instanceName));
    }

    public Set<String> instanceNames() {
        return Collections.unmodifiableSet(this.customizerMap.keySet());
    }
}

