/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.exception.AcquirePermissionCancelledException;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RateLimiter {
    public static RateLimiter of(String name, RateLimiterConfig rateLimiterConfig) {
        return RateLimiter.of(name, rateLimiterConfig, (Map<String, String>)HashMap.empty());
    }

    public static RateLimiter of(String name, RateLimiterConfig rateLimiterConfig, Map<String, String> tags) {
        return new AtomicRateLimiter(name, rateLimiterConfig, tags);
    }

    public static RateLimiter of(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        return RateLimiter.of(name, rateLimiterConfigSupplier.get(), (Map<String, String>)HashMap.empty());
    }

    public static RateLimiter of(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier, Map<String, String> tags) {
        return new AtomicRateLimiter(name, rateLimiterConfigSupplier.get(), tags);
    }

    public static RateLimiter ofDefaults(String name) {
        return new AtomicRateLimiter(name, RateLimiterConfig.ofDefaults());
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(RateLimiter rateLimiter, Supplier<CompletionStage<T>> supplier) {
        return RateLimiter.decorateCompletionStage(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(RateLimiter rateLimiter, int permits, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            try {
                RateLimiter.waitForPermission(rateLimiter, permits);
                ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        promise.completeExceptionally((Throwable)throwable);
                    } else {
                        promise.complete(result);
                    }
                });
            }
            catch (Exception exception) {
                promise.completeExceptionally(exception);
            }
            return promise;
        };
    }

    public static <T, F extends Future<T>> Supplier<F> decorateFuture(RateLimiter rateLimiter, Supplier<? extends F> supplier) {
        return RateLimiter.decorateFuture(rateLimiter, 1, supplier);
    }

    public static <T, F extends Future<T>> Supplier<F> decorateFuture(RateLimiter rateLimiter, int permits, Supplier<? extends F> supplier) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return (Future)supplier.get();
        };
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(RateLimiter rateLimiter, CheckedFunction0<T> supplier) {
        return RateLimiter.decorateCheckedSupplier(rateLimiter, 1, supplier);
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(RateLimiter rateLimiter, int permits, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return supplier.apply();
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(RateLimiter rateLimiter, CheckedRunnable runnable) {
        return RateLimiter.decorateCheckedRunnable(rateLimiter, 1, runnable);
    }

    public static CheckedRunnable decorateCheckedRunnable(RateLimiter rateLimiter, int permits, CheckedRunnable runnable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            runnable.run();
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, CheckedFunction1<T, R> function) {
        return RateLimiter.decorateCheckedFunction(rateLimiter, 1, function);
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, int permits, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return function.apply(t);
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            RateLimiter.waitForPermission(rateLimiter, (Integer)permitsCalculator.apply(t));
            return function.apply(t);
        };
    }

    public static <T> Supplier<T> decorateSupplier(RateLimiter rateLimiter, Supplier<T> supplier) {
        return RateLimiter.decorateSupplier(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<T> decorateSupplier(RateLimiter rateLimiter, int permits, Supplier<T> supplier) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return supplier.get();
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(RateLimiter rateLimiter, Supplier<Try<T>> supplier) {
        return RateLimiter.decorateTrySupplier(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(RateLimiter rateLimiter, int permits, Supplier<Try<T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission(rateLimiter, permits);
                return (Try)supplier.get();
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Try.failure((Throwable)requestNotPermitted);
            }
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(RateLimiter rateLimiter, Supplier<Either<? extends Exception, T>> supplier) {
        return RateLimiter.decorateEitherSupplier(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(RateLimiter rateLimiter, int permits, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission(rateLimiter, permits);
                return Either.narrow((Either)((Either)supplier.get()));
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Either.left((Object)requestNotPermitted);
            }
        };
    }

    public static <T> Callable<T> decorateCallable(RateLimiter rateLimiter, Callable<T> callable) {
        return RateLimiter.decorateCallable(rateLimiter, 1, callable);
    }

    public static <T> Callable<T> decorateCallable(RateLimiter rateLimiter, int permits, Callable<T> callable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return callable.call();
        };
    }

    public static <T> Consumer<T> decorateConsumer(RateLimiter rateLimiter, Consumer<T> consumer) {
        return RateLimiter.decorateConsumer(rateLimiter, 1, consumer);
    }

    public static <T> Consumer<T> decorateConsumer(RateLimiter rateLimiter, int permits, Consumer<T> consumer) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            consumer.accept(t);
        };
    }

    public static <T> Consumer<T> decorateConsumer(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator, Consumer<T> consumer) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter, (Integer)permitsCalculator.apply(t));
            consumer.accept(t);
        };
    }

    public static Runnable decorateRunnable(RateLimiter rateLimiter, Runnable runnable) {
        return RateLimiter.decorateRunnable(rateLimiter, 1, runnable);
    }

    public static Runnable decorateRunnable(RateLimiter rateLimiter, int permits, Runnable runnable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            runnable.run();
        };
    }

    public static <T, R> Function<T, R> decorateFunction(RateLimiter rateLimiter, Function<T, R> function) {
        return RateLimiter.decorateFunction(rateLimiter, 1, function);
    }

    public static <T, R> Function<T, R> decorateFunction(RateLimiter rateLimiter, int permits, Function<T, R> function) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter, permits);
            return function.apply(t);
        };
    }

    public static <T, R> Function<T, R> decorateFunction(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator, Function<T, R> function) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter, (Integer)permitsCalculator.apply(t));
            return function.apply(t);
        };
    }

    public static void waitForPermission(RateLimiter rateLimiter) {
        RateLimiter.waitForPermission(rateLimiter, 1);
    }

    public static void waitForPermission(RateLimiter rateLimiter, int permits) {
        boolean permission = rateLimiter.acquirePermission(permits);
        if (Thread.currentThread().isInterrupted()) {
            throw new AcquirePermissionCancelledException();
        }
        if (!permission) {
            throw RequestNotPermitted.createRequestNotPermitted(rateLimiter);
        }
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return RateLimiter.decorateCompletionStage(this, supplier).get();
    }

    public void changeTimeoutDuration(Duration var1);

    public void changeLimitForPeriod(int var1);

    default public boolean acquirePermission() {
        return this.acquirePermission(1);
    }

    public boolean acquirePermission(int var1);

    default public long reservePermission() {
        return this.reservePermission(1);
    }

    public long reservePermission(int var1);

    public String getName();

    public RateLimiterConfig getRateLimiterConfig();

    public Map<String, String> getTags();

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return this.executeSupplier(1, supplier);
    }

    default public <T> T executeSupplier(int permits, Supplier<T> supplier) {
        return RateLimiter.decorateSupplier(this, permits, supplier).get();
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return this.executeTrySupplier(1, supplier);
    }

    default public <T> Try<T> executeTrySupplier(int permits, Supplier<Try<T>> supplier) {
        return RateLimiter.decorateTrySupplier(this, permits, supplier).get();
    }

    default public <T> Either<Exception, T> executeEitherSupplier(Supplier<Either<? extends Exception, T>> supplier) {
        return this.executeEitherSupplier(1, supplier);
    }

    default public <T> Either<Exception, T> executeEitherSupplier(int permits, Supplier<Either<? extends Exception, T>> supplier) {
        return RateLimiter.decorateEitherSupplier(this, permits, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return this.executeCallable(1, callable);
    }

    default public <T> T executeCallable(int permits, Callable<T> callable) throws Exception {
        return RateLimiter.decorateCallable(this, permits, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        this.executeRunnable(1, runnable);
    }

    default public void executeRunnable(int permits, Runnable runnable) {
        RateLimiter.decorateRunnable(this, permits, runnable).run();
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return this.executeCheckedSupplier(1, checkedSupplier);
    }

    default public <T> T executeCheckedSupplier(int permits, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)RateLimiter.decorateCheckedSupplier(this, permits, checkedSupplier).apply();
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RateLimiterEvent> {
        public EventPublisher onSuccess(EventConsumer<RateLimiterOnSuccessEvent> var1);

        public EventPublisher onFailure(EventConsumer<RateLimiterOnFailureEvent> var1);
    }

    public static interface Metrics {
        public int getNumberOfWaitingThreads();

        public int getAvailablePermissions();
    }
}

