/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.configure.ReactorRetryAspectExt;
import io.github.resilience4j.retry.configure.RetryAspect;
import io.github.resilience4j.retry.configure.RetryAspectExt;
import io.github.resilience4j.retry.configure.RetryConfigurationProperties;
import io.github.resilience4j.retry.configure.RxJava2RetryAspectExt;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.internal.InMemoryRetryRegistry;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RetryConfiguration {
    @Bean
    public RetryRegistry retryRegistry(RetryConfigurationProperties retryConfigurationProperties, EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry) {
        InMemoryRetryRegistry retryRegistry = new InMemoryRetryRegistry();
        retryConfigurationProperties.getBackends().forEach((arg_0, arg_1) -> RetryConfiguration.lambda$retryRegistry$0(retryConfigurationProperties, (RetryRegistry)retryRegistry, retryEventConsumerRegistry, arg_0, arg_1));
        return retryRegistry;
    }

    @Bean
    public RetryAspect retryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList) {
        return new RetryAspect(retryConfigurationProperties, retryRegistry, retryAspectExtList);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class})
    public RxJava2RetryAspectExt rxJava2RetryAspectExt() {
        return new RxJava2RetryAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class})
    public ReactorRetryAspectExt reactorRetryAspectExt() {
        return new ReactorRetryAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private static /* synthetic */ void lambda$retryRegistry$0(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, EventConsumerRegistry retryEventConsumerRegistry, String name, RetryConfigurationProperties.BackendProperties properties) {
        RetryConfig retryConfig = retryConfigurationProperties.createRetryConfig(name);
        Retry retry = retryRegistry.retry(name, retryConfig);
        retry.getEventPublisher().onEvent((EventConsumer)retryEventConsumerRegistry.createEventConsumer(name, properties.getEventConsumerBufferSize().intValue()));
    }
}

