/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger;

import io.github.swagger.DefaultResourcesProvider;
import io.github.swagger.properties.DocketProperties;
import io.github.swagger.properties.SecurityConfigurationProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.CollectionUtils;
import springfox.documentation.swagger.web.ApiResourceController;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConfigurationProperties(value="swagger")
@ConditionalOnProperty(value={"swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    private ConfigurableListableBeanFactory beanFactory;
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private String swaggerUrl;
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;
    @Value(value="${server.port:8080}")
    private String port;
    private List<String> profiles;
    private DocketProperties docket;
    private Map<String, DocketProperties> dockets;
    private SecurityConfigurationProperties securityConfiguration;
    private Boolean printInit = false;
    private DefaultResourcesProvider resourcesProvider;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof AbstractRefreshableApplicationContext) {
            this.beanFactory = ((AbstractRefreshableApplicationContext)applicationContext).getBeanFactory();
        } else {
            this.beanFactory = ((GenericApplicationContext)applicationContext).getBeanFactory();
            this.defaultListableBeanFactory = ((GenericApplicationContext)applicationContext).getDefaultListableBeanFactory();
        }
    }

    @PostConstruct
    public void init() throws NoSuchFieldException, IllegalAccessException {
        String[] activeProfiles = this.applicationContext.getEnvironment().getActiveProfiles();
        if (!CollectionUtils.isEmpty(this.profiles) && !CollectionUtils.containsAny(this.profiles, Arrays.asList(activeProfiles))) {
            return;
        }
        if (this.securityConfiguration != null) {
            SecurityConfiguration configuration = this.securityConfiguration.toSecurityConfiguration();
            this.beanFactory.registerSingleton("swaggerSecurityConfiguration", (Object)configuration);
            this.registerSource("securityConfiguration", configuration);
        }
        if (this.resourcesProvider != null) {
            this.registerSource("swaggerResources", this.resourcesProvider);
            log.info(this.resourcesProvider.toString());
            this.swaggerUrl = "http://localhost:" + this.port + (this.contextPath + "/swagger-ui.html").replaceAll("//", "/");
        }
        ArrayList<String> beanNameList = new ArrayList<String>();
        if (this.dockets != null && this.dockets.size() > 0) {
            this.dockets.forEach((beanName, properties) -> this.registerDocket((String)beanName, (DocketProperties)properties, (List<String>)beanNameList));
        }
        if (this.docket != null) {
            this.registerDocket("swagger_docket", this.docket, beanNameList);
        }
        log.info(String.format("%sinitialization completed, swagger url: %s", beanNameList.isEmpty() ? "" : ((Object)beanNameList).toString() + " ", this.swaggerUrl));
    }

    private void registerSource(String fieldName, Object fieldValue) throws NoSuchFieldException, IllegalAccessException {
        String[] names = this.beanFactory.getBeanNamesForType(ApiResourceController.class);
        if (names.length == 1 && this.defaultListableBeanFactory != null) {
            ApiResourceController apiResourceController = (ApiResourceController)this.defaultListableBeanFactory.getSingleton(names[0]);
            this.defaultListableBeanFactory.destroySingleton(names[0]);
            Field field = ApiResourceController.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(apiResourceController, fieldValue);
            this.defaultListableBeanFactory.registerSingleton(names[0], (Object)apiResourceController);
        }
    }

    private void registerDocket(String beanName, DocketProperties properties, List<String> beanNameList) {
        if (this.printInit.booleanValue()) {
            log.info(properties.toString().replaceFirst(DocketProperties.class.getSimpleName(), beanName).replaceAll("Properties", ""));
        }
        this.beanFactory.registerSingleton(beanName, (Object)properties.toDocket(beanName, this.contextPath));
        beanNameList.add(beanName);
        this.swaggerUrl = "http://" + (properties.getHost() + ":" + this.port + this.contextPath + "/swagger-ui.html").replaceAll("//", "/");
    }

    public void setDocket(DocketProperties docket) {
        this.docket = docket;
    }

    public void setDockets(Map<String, DocketProperties> dockets) {
        this.dockets = dockets;
    }

    public void setSecurityConfiguration(SecurityConfigurationProperties securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public void setPrintInit(Boolean printInit) {
        this.printInit = printInit;
    }

    public void setResourcesProvider(DefaultResourcesProvider resourcesProvider) {
        this.resourcesProvider = resourcesProvider;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }
}

