/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import io.github.swagger.properties.ApiInfoProperties;
import io.github.swagger.properties.DefaultPathProvider;
import io.github.swagger.properties.ParameterProperties;
import io.github.swagger.properties.PathSelectorsProperties;
import io.github.swagger.properties.ResponseMessageProperties;
import io.github.swagger.properties.SecurityContextProperties;
import io.github.swagger.properties.SecuritySchemeProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

public class DocketProperties {
    public static final String DEFAULT_DOCKET = "swagger_docket";
    private static final String LANGUAGE_EN = "en";
    private String pathMapping = "/";
    private String host = "localhost";
    private String groupName;
    private String basePackage;
    private Set<String> protocols = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private Set<String> produces = Sets.newHashSet((Object[])new String[]{"application/json"});
    private Set<String> consumes = Sets.newHashSet((Object[])new String[]{"application/json"});
    private List<ParameterProperties> globalParameters = new ArrayList<ParameterProperties>();
    private ParameterProperties globalParameter;
    private ApiInfoProperties apiInfo = new ApiInfoProperties();
    private List<ResponseMessageProperties> responseMessages = new ArrayList<ResponseMessageProperties>();
    private String responseMessageLanguage = "en";
    private PathSelectorsProperties pathSelectors;
    private List<SecurityContextProperties> securityContexts;
    private SecuritySchemeProperties securitySchemes;
    private Class<?>[] ignoredParameterTypes;
    private List<Class> directModelSubstitutes;
    private Class<?>[] genericModelSubstitutes;

    public Docket toDocket(String beanName, String contextPath) {
        List<ResponseMessage> responseMessages = this.toResponseMessages();
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        if (this.directModelSubstitutes != null && this.directModelSubstitutes.size() % 2 == 0) {
            IntStream.range(0, this.directModelSubstitutes.size()).filter(i -> i % 2 == 0).forEach(i -> docket.directModelSubstitute(this.directModelSubstitutes.get(i), this.directModelSubstitutes.get(i + 1)));
        }
        docket.pathMapping(this.pathMapping).genericModelSubstitutes(Optional.ofNullable(this.genericModelSubstitutes).orElse(new Class[0])).pathProvider((PathProvider)(Objects.equals(DEFAULT_DOCKET, beanName) ? new DefaultPathProvider(contextPath) : null)).groupName(this.groupName).securityContexts(this.toSecurityContexts()).securitySchemes(this.toSecuritySchemes()).apiInfo(this.apiInfo.toApiInfo()).globalOperationParameters(this.toGlobalParameters()).protocols(this.protocols).produces(this.produces).consumes(this.consumes).globalResponseMessage(RequestMethod.GET, responseMessages).globalResponseMessage(RequestMethod.PUT, responseMessages).globalResponseMessage(RequestMethod.POST, responseMessages).globalResponseMessage(RequestMethod.DELETE, responseMessages).ignoredParameterTypes(Optional.ofNullable(this.ignoredParameterTypes).orElse(new Class[0]));
        return this.basePackage == null ? docket : docket.select().apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).paths(this.toPathSelector()).build();
    }

    private List<Parameter> toGlobalParameters() {
        if (this.globalParameter != null && this.globalParameters.isEmpty()) {
            this.globalParameters.add(this.globalParameter);
        }
        return this.globalParameters.stream().map(ParameterProperties::build).collect(Collectors.toList());
    }

    private Predicate<String> toPathSelector() {
        if (this.pathSelectors == null || this.pathSelectors.isEmpty()) {
            return PathSelectors.any();
        }
        Predicate includePaths = this.pathSelectors.getIncludePatterns().stream().map(PathSelectors::ant).reduce(Predicates::or).orElse(Predicates.alwaysTrue());
        Predicate excludePaths = this.pathSelectors.getExcludePatterns().stream().map(e -> Predicates.not((Predicate)PathSelectors.ant((String)e))).reduce(Predicates::or).orElse(null);
        return excludePaths == null ? Predicates.and((Predicate[])new Predicate[]{includePaths}) : Predicates.and((Predicate)includePaths, (Predicate)excludePaths);
    }

    private List<ResponseMessage> toResponseMessages() {
        List<ResponseMessage> defaults = LANGUAGE_EN.equals(this.responseMessageLanguage) ? ResponseMessageProperties.DEFAULT_EN_MESSAGES : ResponseMessageProperties.DEFAULT_CN_MESSAGES;
        this.responseMessages.forEach(e -> defaults.add(e.toResponseMessage(null)));
        return defaults;
    }

    private List<SecurityContext> toSecurityContexts() {
        return this.securityContexts == null || this.securityContexts.isEmpty() ? Collections.emptyList() : this.securityContexts.stream().map(SecurityContextProperties::toSecurityContext).collect(Collectors.toList());
    }

    private List<SecurityScheme> toSecuritySchemes() {
        return this.securitySchemes == null ? Collections.emptyList() : this.securitySchemes.toSecuritySchemes();
    }

    public String getHost() {
        return this.host;
    }

    public void setPathMapping(String pathMapping) {
        this.pathMapping = pathMapping;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setProtocols(Set<String> protocols) {
        this.protocols = protocols;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public void setGlobalParameters(List<ParameterProperties> globalParameters) {
        this.globalParameters = globalParameters;
    }

    public void setGlobalParameter(ParameterProperties globalParameter) {
        this.globalParameter = globalParameter;
    }

    public void setApiInfo(ApiInfoProperties apiInfo) {
        this.apiInfo = apiInfo;
    }

    public void setResponseMessages(List<ResponseMessageProperties> responseMessages) {
        this.responseMessages = responseMessages;
    }

    public void setResponseMessageLanguage(String responseMessageLanguage) {
        this.responseMessageLanguage = responseMessageLanguage;
    }

    public void setPathSelectors(PathSelectorsProperties pathSelectors) {
        this.pathSelectors = pathSelectors;
    }

    public void setSecurityContexts(List<SecurityContextProperties> securityContexts) {
        this.securityContexts = securityContexts;
    }

    public void setSecuritySchemes(SecuritySchemeProperties securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public void setIgnoredParameterTypes(Class<?>[] ignoredParameterTypes) {
        this.ignoredParameterTypes = ignoredParameterTypes;
    }

    public void setDirectModelSubstitutes(List<Class> directModelSubstitutes) {
        this.directModelSubstitutes = directModelSubstitutes;
    }

    public void setGenericModelSubstitutes(Class<?>[] genericModelSubstitutes) {
        this.genericModelSubstitutes = genericModelSubstitutes;
    }

    public String toString() {
        return "DocketProperties(pathMapping=" + this.pathMapping + ", host=" + this.getHost() + ", groupName=" + this.groupName + ", basePackage=" + this.basePackage + ", protocols=" + this.protocols + ", produces=" + this.produces + ", consumes=" + this.consumes + ", globalParameters=" + this.globalParameters + ", globalParameter=" + this.globalParameter + ", apiInfo=" + this.apiInfo + ", responseMessages=" + this.responseMessages + ", responseMessageLanguage=" + this.responseMessageLanguage + ", pathSelectors=" + this.pathSelectors + ", securityContexts=" + this.securityContexts + ", securitySchemes=" + this.securitySchemes + ", ignoredParameterTypes=" + Arrays.deepToString(this.ignoredParameterTypes) + ", directModelSubstitutes=" + this.directModelSubstitutes + ", genericModelSubstitutes=" + Arrays.deepToString(this.genericModelSubstitutes) + ")";
    }
}

