/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Header;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.VendorExtension;

public class ResponseMessageProperties {
    private Integer code;
    private String message;
    private String modelRef;
    private Map<String, Header> headers = Maps.newTreeMap();
    private List<VendorExtension> vendorExtensions = Lists.newArrayList();
    public static final List<ResponseMessage> DEFAULT_EN_MESSAGES = new ArrayList<ResponseMessage>(8);
    public static final List<ResponseMessage> DEFAULT_CN_MESSAGES = new ArrayList<ResponseMessage>(8);

    private ResponseMessageProperties(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public void setMessage(String message) {
        this.message = (String)BuilderDefaults.defaultIfAbsent((Object)message, (Object)this.message);
    }

    ResponseMessage toResponseMessage(ModelRef modelRef) {
        return new ResponseMessage(this.code.intValue(), this.message, (ModelReference)modelRef, this.headers, this.vendorExtensions);
    }

    public String toString() {
        return "ResponseMessageProperties(code=" + this.code + ", message=" + this.message + ", modelRef=" + this.modelRef + ", headers=" + this.headers + ", vendorExtensions=" + this.vendorExtensions + ")";
    }

    public ResponseMessageProperties() {
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setModelRef(String modelRef) {
        this.modelRef = modelRef;
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    public void setVendorExtensions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    static {
        DEFAULT_EN_MESSAGES.add(new ResponseMessageProperties(401, "Unauthorized").toResponseMessage(null));
        DEFAULT_EN_MESSAGES.add(new ResponseMessageProperties(403, "Forbidden").toResponseMessage(null));
        DEFAULT_EN_MESSAGES.add(new ResponseMessageProperties(404, "Page Not Found").toResponseMessage(null));
        DEFAULT_EN_MESSAGES.add(new ResponseMessageProperties(500, "Server Internal Error").toResponseMessage(null));
        DEFAULT_CN_MESSAGES.add(new ResponseMessageProperties(401, "\u8bf7\u5148\u767b\u5f55").toResponseMessage(null));
        DEFAULT_CN_MESSAGES.add(new ResponseMessageProperties(403, "\u6743\u9650\u4e0d\u8db3").toResponseMessage(null));
        DEFAULT_CN_MESSAGES.add(new ResponseMessageProperties(404, "\u9875\u9762\u4e0d\u5b58\u5728").toResponseMessage(null));
        DEFAULT_CN_MESSAGES.add(new ResponseMessageProperties(500, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef").toResponseMessage(null));
    }
}

