/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties;

import io.github.swagger.properties.schema.ApiKeyProperties;
import io.github.swagger.properties.schema.OAuthProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.SecurityScheme;

class SecuritySchemeProperties {
    private List<String> basicAuthList = new ArrayList<String>();
    private List<OAuthProperties> oauthList = new ArrayList<OAuthProperties>();
    private List<ApiKeyProperties> apiKeyList = new ArrayList<ApiKeyProperties>();

    SecuritySchemeProperties() {
    }

    public List<SecurityScheme> toSecuritySchemes() {
        ArrayList<SecurityScheme> list = new ArrayList<SecurityScheme>(this.basicAuthList.size() + this.oauthList.size() + this.apiKeyList.size());
        this.basicAuthList.forEach(e -> list.add((SecurityScheme)new BasicAuth(e)));
        list.addAll(this.oauthList.stream().map(OAuthProperties::toOAuth).collect(Collectors.toList()));
        list.addAll(this.apiKeyList.stream().map(ApiKeyProperties::toApiKey).collect(Collectors.toList()));
        return list;
    }

    public void setBasicAuthList(List<String> basicAuthList) {
        this.basicAuthList = basicAuthList;
    }

    public void setOauthList(List<OAuthProperties> oauthList) {
        this.oauthList = oauthList;
    }

    public void setApiKeyList(List<ApiKeyProperties> apiKeyList) {
        this.apiKeyList = apiKeyList;
    }

    public String toString() {
        return "SecuritySchemeProperties(basicAuthList=" + this.basicAuthList + ", oauthList=" + this.oauthList + ", apiKeyList=" + this.apiKeyList + ")";
    }
}

