/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws;

import io.gravitee.ae.connector.ws.Endpoint;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.gravitee.ae.connector.ws.configuration.Engine;
import io.gravitee.common.component.AbstractLifecycleComponent;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

public abstract class AbstractConnector<T>
extends AbstractLifecycleComponent<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractConnector.class);
    protected HttpClient httpClient;
    @Autowired
    protected Vertx vertx;
    @Value(value="${alerts.alert-engine.enabled:false}")
    protected boolean enabled;
    @Value(value="${alerts.alert-engine.ws.discovery:true}")
    protected boolean discovery;
    @Autowired
    protected ConnectorConfiguration connectorConfiguration;

    protected void doStop() throws Exception {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IllegalStateException ise) {
                this.logger.warn(ise.getMessage());
            }
        }
    }

    public abstract Future<Void> writeTextMessage(String var1);

    protected void initHttpClient(Engine engine) {
        Assert.notNull((Object)engine, (String)"Engine can not be null");
        Endpoint endpoint = engine.nextEndpoint();
        this.httpClient = this.vertx.createHttpClient(engine.getHttpClientOptions(endpoint));
    }

    protected MultiMap getDefaultHeaders(Engine engine) {
        HeadersMultiMap headers = HeadersMultiMap.httpHeaders();
        if (engine.getSecurity().getUsername() != null) {
            String basicAuthorizationHeader = this.initEncodedAuthorization(engine.getSecurity().getUsername(), engine.getSecurity().getPassword());
            headers.set("Authorization", basicAuthorizationHeader);
        }
        return headers;
    }

    protected String initEncodedAuthorization(String username, String password) {
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + encodedAuth;
    }
}

