/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws;

import io.gravitee.ae.connector.ws.AbstractConnector;
import io.gravitee.ae.connector.ws.configuration.Engine;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector
extends AbstractConnector<HttpConnector> {
    private final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private final Engine engine;
    private final String path;

    public HttpConnector(Engine engine, String path) {
        this.engine = engine;
        this.path = path;
    }

    protected void doStart() {
        if (this.enabled) {
            this.logger.info("AlertEngine connector is enabled. Starting http connector.");
            this.initHttpClient(this.engine);
            this.logger.info("Channel is ready to send data to Alert Engine through http");
        } else {
            this.logger.info("AlertEngine connector is disabled.");
        }
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        Promise promise = Promise.promise();
        if (this.httpClient != null) {
            RequestOptions requestOptions = new RequestOptions().setURI(this.path).setHeaders(this.getDefaultHeaders(this.engine)).setMethod(HttpMethod.POST).setTimeout((long)this.connectorConfiguration.getRequestTimeout());
            this.httpClient.request(requestOptions).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(httpClientRequest -> httpClientRequest.send(Buffer.buffer((String)text)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(httpResponse -> {
                if (httpResponse.statusCode() >= 200 && httpResponse.statusCode() <= 299) {
                    promise.complete();
                    this.logger.debug("Events successfully sent.");
                } else {
                    promise.fail("Unable to send events. Server replies with status " + httpResponse.statusCode());
                }
            }));
        } else {
            promise.fail("The connector is not yet ready");
        }
        return promise.future();
    }
}

