/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws;

import io.gravitee.ae.connector.api.command.Command;
import io.gravitee.ae.connector.ws.AbstractConnector;
import io.gravitee.ae.connector.ws.Endpoint;
import io.gravitee.ae.connector.ws.command.CommandHandlerManager;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.gravitee.ae.connector.ws.configuration.Engine;
import io.gravitee.ae.connector.ws.listener.ListenerManager;
import io.gravitee.alert.api.event.EventProducer;
import io.gravitee.alert.api.trigger.TriggerProvider;
import io.gravitee.node.api.Node;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WebSocketConnector
extends AbstractConnector<WebSocketConnector> {
    private static final String HTTPS_SCHEME = "https";
    private final Logger logger = LoggerFactory.getLogger(WebSocketConnector.class);
    private static final long PING_HANDLER_DELAY = 5000L;
    @Autowired
    private ListenerManager listenerManager;
    @Autowired
    private Node node;
    private WebSocket webSocket;
    private long pongHandlerId;
    private CircuitBreaker circuitBreaker;
    private final Engine engine;
    private final String path;
    @Autowired
    private CommandHandlerManager commandHandlerManager;

    public WebSocketConnector(Engine engine, String path) {
        this.engine = engine;
        this.path = path;
    }

    protected void doStart() {
        if (this.enabled) {
            this.logger.info("AlertEngine connector is enabled. Starting WS connector.");
            this.circuitBreaker = CircuitBreaker.create((String)"alert-engine-event-producer", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxRetries(Integer.MAX_VALUE).setNotificationAddress(null));
            this.circuitBreaker.retryPolicy(integer -> 5000L);
            this.connect();
        } else {
            this.logger.info("AlertEngine connector is disabled.");
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.pongHandlerId != 0L) {
            this.vertx.cancelTimer(this.pongHandlerId);
        }
    }

    private void connect() {
        this.circuitBreaker.execute(this::doConnect).onComplete(event -> {
            if (event.succeeded()) {
                this.webSocket = (WebSocket)event.result();
                this.pongHandlerId = this.vertx.setPeriodic(5000L, aLong -> this.webSocket.writePing(Buffer.buffer((String)(this.node.id() + " - " + this.node.hostname()))));
                if (this.discovery) {
                    this.logger.info("Discovery mode is enabled, listening for alert engine instances...");
                }
                this.webSocket.handler(buffer -> {
                    String sCommand = buffer.toString();
                    try {
                        Command command = (Command)DatabindCodec.mapper().readValue(sCommand, Command.class);
                        this.commandHandlerManager.handle(command, result -> {
                            if (result != null) {
                                this.webSocket.writeTextMessage("reply:" + command.id() + ":" + Json.encode((Object)result));
                            }
                        });
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unexpected error while reading command: {}", (Object)sCommand, (Object)ioe);
                    }
                });
                this.webSocket.exceptionHandler(throwable -> this.logger.error("An error occurred on the websocket connection", throwable));
                this.webSocket.pongHandler(data -> this.logger.debug("Get a pong from Alert Engine server"));
                this.webSocket.closeHandler(event1 -> {
                    this.logger.debug("Connection to Alert Engine server has been closed.");
                    if (this.pongHandlerId != 0L) {
                        this.vertx.cancelTimer(this.pongHandlerId);
                    }
                    this.webSocket = null;
                    this.invokeOnDisconnectionListeners();
                    this.connect();
                });
                this.invokeOnConnectionListeners();
            } else {
                this.connect();
            }
        });
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        if (this.webSocket != null) {
            if (!this.webSocket.writeQueueFull()) {
                return this.webSocket.writeTextMessage(text);
            }
            return Future.failedFuture((String)"An alert event has been skipped, write queue full...");
        }
        return Future.failedFuture((String)"The connector is not yet ready");
    }

    private void doConnect(Promise<WebSocket> webSocketPromise) {
        this.initHttpClient(this.engine);
        Endpoint endpoint = this.engine.currentEndpoint();
        if (endpoint != null) {
            URI target = URI.create(endpoint.getUrl());
            WebSocketConnectOptions webSocketConnectOptions = new WebSocketConnectOptions();
            webSocketConnectOptions.setHeaders(this.getDefaultHeaders(this.engine));
            webSocketConnectOptions.setURI(target.getRawPath() + this.path);
            ConnectorConfiguration connectorConfig = this.engine.getConnectorConfiguration();
            if (connectorConfig.isUseSystemProxy()) {
                ProxyOptions proxyOptions = new ProxyOptions().setType(ProxyType.valueOf((String)connectorConfig.getProxyType()));
                if (HTTPS_SCHEME.equals(target.getScheme())) {
                    webSocketConnectOptions.setProxyOptions(proxyOptions.setHost(connectorConfig.getProxyHttpsHost()).setPort(connectorConfig.getProxyHttpsPort()).setUsername(connectorConfig.getProxyHttpsUsername()).setPassword(connectorConfig.getProxyHttpsPassword()));
                } else {
                    webSocketConnectOptions.setProxyOptions(proxyOptions.setHost(connectorConfig.getProxyHttpHost()).setPort(connectorConfig.getProxyHttpPort()).setUsername(connectorConfig.getProxyHttpUsername()).setPassword(connectorConfig.getProxyHttpPassword()));
                }
            }
            this.httpClient.webSocket(webSocketConnectOptions).onSuccess(ws -> {
                this.engine.resetEndpointRetryCount(endpoint);
                this.logger.info("Channel is ready to send data to Alert Engine through websocket from {}", (Object)(endpoint.getUrl() + this.path));
                webSocketPromise.complete(ws);
            }).onFailure(throwable -> {
                this.logger.error("An error occurred while trying to connect to the alert engine: {} [{} times]", (Object)throwable.getMessage(), (Object)this.engine.getEndpointRetryCount(endpoint));
                webSocketPromise.fail(throwable);
                this.httpClient.close();
            });
        }
    }

    private void invokeOnConnectionListeners() {
        if (this.path.equals("/ws/triggers")) {
            this.listenerManager.getListeners(TriggerProvider.OnConnectionListener.class).forEach(TriggerProvider.OnConnectionListener::doOnConnect);
        } else if (this.path.equals("/ws/events")) {
            this.listenerManager.getListeners(EventProducer.OnConnectionListener.class).forEach(EventProducer.OnConnectionListener::doOnConnect);
        }
    }

    private void invokeOnDisconnectionListeners() {
        if (this.path.equals("/ws/triggers")) {
            this.listenerManager.getListeners(TriggerProvider.OnDisconnectionListener.class).forEach(TriggerProvider.OnDisconnectionListener::doOnDisconnect);
        } else if (this.path.equals("/ws/events")) {
            this.listenerManager.getListeners(EventProducer.OnDisconnectionListener.class).forEach(EventProducer.OnDisconnectionListener::doOnDisconnect);
        }
    }
}

