/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.ae.connector.core.ContextBuilder;
import io.gravitee.ae.connector.core.probe.AlertProbe;
import io.gravitee.ae.connector.ws.AbstractConnector;
import io.gravitee.ae.connector.ws.HttpConnector;
import io.gravitee.ae.connector.ws.WebSocketConnector;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.gravitee.ae.connector.ws.configuration.Engine;
import io.gravitee.ae.connector.ws.listener.ListenerManager;
import io.gravitee.alert.api.Listener;
import io.gravitee.alert.api.event.AbstractEventProducer;
import io.gravitee.alert.api.event.Context;
import io.gravitee.alert.api.event.DefaultEvent;
import io.gravitee.alert.api.event.Event;
import io.gravitee.alert.api.event.EventProducer;
import io.gravitee.node.api.healthcheck.ProbeManager;
import io.gravitee.node.api.healthcheck.Result;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.vertx.core.impl.ConcurrentHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WsEventProducer
extends AbstractEventProducer
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(WsEventProducer.class);
    private static final int MAX_PENDING_EVENTS = 1000;
    public static final String WS_EVENT_PATH = "/ws/events";
    public static final String HTTP_EVENT_PATH = "/http/events";
    private final ObjectMapper mapper = new ObjectMapper();
    private AbstractConnector<?> connector;
    private ApplicationContext applicationContext;
    @Autowired
    private ListenerManager listenerManager;
    @Autowired
    private ContextBuilder contextBuilder;
    @Autowired
    private ConnectorConfiguration configuration;
    @Autowired
    ProbeManager probeManager;
    @Autowired
    private AlertProbe alertProbe;
    private Context context;
    private final Set<Event> pendingEvents = new ConcurrentHashSet();
    private FlowableEmitter<Event> eventEmitter;

    public void send(Event event) {
        if (this.eventEmitter == null) {
            if (this.pendingEvents.size() < 1000) {
                this.pendingEvents.add(event);
            } else {
                this.alertProbe.addDroppedEvents(1);
            }
        } else {
            this.eventEmitter.onNext((Object)event);
        }
    }

    protected void doStart() throws Exception {
        this.context = this.contextBuilder.build();
        Flowable bufferedEvents = Flowable.create(this::prepareEventEmitter, (BackpressureStrategy)BackpressureStrategy.LATEST).doOnNext(this::copyContextToEvent);
        this.logger.info("AlertEngine connector is enabled. Starting connector.");
        Engine defaultEngine = this.configuration.getDefaultEngine();
        if (this.configuration.isSendEventsOnHttp()) {
            this.connector = new HttpConnector(defaultEngine, HTTP_EVENT_PATH);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean(this.connector);
            this.connector.start();
            bufferedEvents.buffer((long)this.configuration.getBulkEventsWait(), TimeUnit.MILLISECONDS, this.configuration.getBulkEventsSize()).doOnNext(this::writeEvents).onBackpressureDrop(events -> this.alertProbe.setUnhealthy(events.size(), (Throwable)new RuntimeException("AE is overloaded."))).observeOn(Schedulers.computation()).subscribe(events -> {}, throwable -> {});
        } else {
            this.connector = new WebSocketConnector(defaultEngine, WS_EVENT_PATH);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean(this.connector);
            this.listenerManager.addListener((Listener)((EventProducer.OnConnectionListener)() -> bufferedEvents.doOnNext(this::writeEvent).onBackpressureDrop(event -> this.alertProbe.setUnhealthy(1, (Throwable)new RuntimeException("AE is overloaded."))).observeOn(Schedulers.computation()).subscribe(events -> {}, throwable -> {})));
            this.connector.start();
        }
        this.alertProbe.setReady();
    }

    private void prepareEventEmitter(FlowableEmitter<Event> emitter) {
        this.eventEmitter = emitter;
        this.pendingEvents.forEach(event -> this.eventEmitter.onNext(event));
        this.pendingEvents.clear();
    }

    private void copyContextToEvent(Event event) {
        if (this.context != null) {
            if (event.properties() == null && event instanceof DefaultEvent) {
                ((DefaultEvent)event).setProperties(new HashMap());
            }
            if (event.properties() != null) {
                this.context.forEach((k, v) -> event.properties().putIfAbsent(k, v));
            }
        }
    }

    private void writeEvents(List<Event> eventList) {
        if (!eventList.isEmpty()) {
            try {
                this.connector.writeTextMessage(this.mapper.writeValueAsString(eventList)).onSuccess(aVoid -> this.alertProbe.setHealthy()).onFailure(throwable -> {
                    if (this.isCurrentlyHealthy()) {
                        this.logger.warn("An error occurred trying to send events: {}", (Object)throwable.getMessage());
                    }
                    this.alertProbe.setUnhealthy(eventList.size(), throwable);
                });
            }
            catch (Exception e) {
                if (this.isCurrentlyHealthy()) {
                    this.logger.error("Unexpected error while writing event", (Throwable)e);
                }
                this.alertProbe.setUnhealthy(eventList.size(), (Throwable)e);
            }
        }
    }

    private boolean isCurrentlyHealthy() {
        try {
            return ((Result)this.alertProbe.check().toCompletableFuture().get()).isHealthy();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void writeEvent(Event event) {
        if (event != null) {
            try {
                this.connector.writeTextMessage(this.mapper.writeValueAsString((Object)event)).onSuccess(aVoid -> this.alertProbe.setHealthy()).onFailure(throwable -> {
                    if (this.isCurrentlyHealthy()) {
                        this.logger.warn("An error occurred trying to send event: {}", (Object)throwable.getMessage());
                    }
                    this.alertProbe.setUnhealthy(1, throwable);
                });
            }
            catch (Exception e) {
                if (this.isCurrentlyHealthy()) {
                    this.logger.error("Unexpected error while writing event", (Throwable)e);
                }
                this.alertProbe.setUnhealthy(1, (Throwable)e);
            }
        }
    }

    protected void doStop() throws Exception {
        TimeUnit.MILLISECONDS.sleep(this.configuration.getBulkEventsWait());
        this.connector.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

