/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.ae.connector.core.ContextBuilder;
import io.gravitee.ae.connector.ws.WebSocketConnector;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.gravitee.ae.connector.ws.configuration.Engine;
import io.gravitee.ae.connector.ws.listener.ListenerManager;
import io.gravitee.alert.api.Listener;
import io.gravitee.alert.api.condition.StringCondition;
import io.gravitee.alert.api.event.Context;
import io.gravitee.alert.api.trigger.AbstractTriggerProvider;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.alert.api.trigger.TriggerProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WsTriggerProvider
extends AbstractTriggerProvider
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(WsTriggerProvider.class);
    public static final String WS_TRIGGER_PATH = "/ws/triggers";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<Engine, WebSocketConnector> engineWebSocketConnectorMap = new HashMap<Engine, WebSocketConnector>();
    @Autowired
    private ConnectorConfiguration connectorConfiguration;
    @Autowired
    private ListenerManager listenerManager;
    @Autowired
    private ContextBuilder contextBuilder;
    private Context context;
    private ApplicationContext applicationContext;

    public void register(Trigger trigger) {
        try {
            String installationId;
            String string = installationId = this.context != null ? (String)this.context.get((Object)"installation") : null;
            if (installationId != null) {
                StringCondition installationFilter = StringCondition.equals((String)"installation", (String)installationId).build();
                if (trigger.getFilters() == null) {
                    trigger.setFilters(new ArrayList());
                } else {
                    trigger.setFilters(new ArrayList(trigger.getFilters()));
                }
                trigger.getFilters().add(installationFilter);
            }
            String value = this.mapper.writeValueAsString((Object)trigger);
            this.engineWebSocketConnectorMap.forEach((engine, webSocketConnector) -> webSocketConnector.writeTextMessage(value));
        }
        catch (JsonProcessingException jpe) {
            this.logger.error("Unexpected error while transforming the trigger into a json format", (Throwable)jpe);
        }
    }

    public void unregister(Trigger trigger) {
        try {
            String value = this.mapper.writeValueAsString((Object)trigger);
            this.engineWebSocketConnectorMap.forEach((engine, webSocketConnector) -> webSocketConnector.writeTextMessage(value));
        }
        catch (JsonProcessingException jpe) {
            this.logger.error("Unexpected error while transforming the trigger into a json format", (Throwable)jpe);
        }
    }

    public void addListener(TriggerProvider.Listener listener) {
        this.listenerManager.addListener((Listener)listener);
    }

    protected void doStart() throws Exception {
        this.context = this.contextBuilder.build();
        this.logger.info("AlertEngine connector is enabled. Starting connector.");
        for (Map.Entry<String, Engine> entry : this.connectorConfiguration.getEngines().entrySet()) {
            Engine engine = entry.getValue();
            WebSocketConnector webSocketConnector = new WebSocketConnector(engine, WS_TRIGGER_PATH);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)webSocketConnector);
            webSocketConnector.start();
            this.engineWebSocketConnectorMap.put(engine, webSocketConnector);
        }
    }

    protected void doStop() throws Exception {
        for (WebSocketConnector webSocketConnector : this.engineWebSocketConnectorMap.values()) {
            webSocketConnector.stop();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

