/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws.command;

import io.gravitee.ae.connector.api.command.Command;
import io.gravitee.ae.connector.api.command.Handler;
import io.gravitee.ae.connector.ws.command.CommandHandler;
import io.gravitee.ae.connector.ws.command.CommandHandlerManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommandHandlerManagerImpl
implements CommandHandlerManager {
    private final Logger logger = LoggerFactory.getLogger(CommandHandlerManagerImpl.class);
    @Autowired
    private List<CommandHandler<? extends Command>> commandHandlers;
    private final Map<Command.Type, CommandHandler> handlers = new HashMap<Command.Type, CommandHandler>();

    @PostConstruct
    private void init() {
        this.commandHandlers.forEach(command -> this.handlers.put(command.getSupportedType(), (CommandHandler)command));
    }

    @Override
    public void handle(Command command, Handler resultHandler) {
        CommandHandler handler = this.handlers.get(command.type());
        if (handler == null) {
            this.logger.error("No handler found to handle command of type {}", (Object)command.type());
        } else {
            handler.handle(command, resultHandler);
        }
    }
}

