/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws.command.discovery;

import io.gravitee.ae.connector.api.command.Command;
import io.gravitee.ae.connector.api.command.Handler;
import io.gravitee.ae.connector.api.command.NodeDiscoveryCommand;
import io.gravitee.ae.connector.ws.command.CommandHandler;
import io.gravitee.ae.connector.ws.command.discovery.DynamicEndpoint;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.gravitee.ae.connector.ws.configuration.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class NodeDiscoveryCommandHandler
implements CommandHandler<NodeDiscoveryCommand> {
    private final Logger logger = LoggerFactory.getLogger(NodeDiscoveryCommandHandler.class);
    private static final String DISCOVERY_NODE_REMOVED = "REMOVE";
    private static final String DISCOVERY_NODE_CHANGED = "CHANGE";
    @Autowired
    private ConnectorConfiguration connectorConfiguration;
    @Value(value="${alerts.alert-engine.ws.discovery:true}")
    private boolean discovery;

    @Override
    public Command.Type getSupportedType() {
        return Command.Type.NODE_DISCOVERY;
    }

    @Override
    public void handle(NodeDiscoveryCommand command, Handler resultHandler) {
        DynamicEndpoint websocketEndpoint = new DynamicEndpoint(command.getMember(), command.getEndpoint());
        if (this.discovery) {
            Engine defaultEngine = this.connectorConfiguration.getDefaultEngine();
            if (DISCOVERY_NODE_CHANGED.equalsIgnoreCase(command.getAction())) {
                if (defaultEngine.getEndpoints().stream().noneMatch(edpt -> edpt.getUrl().equals(websocketEndpoint.getUrl()))) {
                    this.logger.info("An alert engine instance has been discovered at {}", (Object)websocketEndpoint.getUrl());
                    defaultEngine.getEndpoints().add(websocketEndpoint);
                }
            } else if (DISCOVERY_NODE_REMOVED.equalsIgnoreCase(command.getAction())) {
                this.logger.info("An alert engine instance has been removed from {}", (Object)websocketEndpoint.getUrl());
                defaultEngine.getEndpoints().remove(websocketEndpoint);
            }
        }
        resultHandler.handle(null);
    }
}

