/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws.configuration;

import io.gravitee.ae.connector.ws.Endpoint;
import io.gravitee.ae.connector.ws.configuration.Engine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class ConnectorConfiguration {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8072";
    private static final String DEFAULT_ENGINE_NAME = "default";
    private final Environment environment;
    @Value(value="${alerts.alert-engine.ws.security.username:#{null}}")
    private String username;
    @Value(value="${alerts.alert-engine.ws.security.password:#{null}}")
    private String password;
    @Value(value="${alerts.alert-engine.ws.ssl.keystore.type:#{null}}")
    private String keystoreType;
    @Value(value="${alerts.alert-engine.ws.ssl.keystore.path:#{null}}")
    private String keystorePath;
    @Value(value="${alerts.alert-engine.ws.ssl.keystore.password:#{null}}")
    private String keystorePassword;
    private List<String> keystorePemCerts;
    private List<String> keystorePemKeys;
    @Value(value="${alerts.alert-engine.ws.ssl.trustall:false}")
    private boolean trustAll;
    @Value(value="${alerts.alert-engine.ws.ssl.verifyHostname:true}")
    private boolean hostnameVerifier;
    @Value(value="${alerts.alert-engine.ws.ssl.truststore.type:#{null}}")
    private String truststoreType;
    @Value(value="${alerts.alert-engine.ws.ssl.truststore.path:#{null}}")
    private String truststorePath;
    @Value(value="${alerts.alert-engine.ws.ssl.truststore.password:#{null}}")
    private String truststorePassword;
    @Value(value="${alerts.alert-engine.ws.connectTimeout:5000}")
    private int connectTimeout;
    @Value(value="${alerts.alert-engine.ws.requestTimeout:2000}")
    private int requestTimeout;
    @Value(value="${alerts.alert-engine.ws.idleTimeout:120000}")
    private int idleTimeout;
    @Value(value="${alerts.alert-engine.ws.keepAlive:true}")
    private boolean keepAlive;
    @Value(value="${alerts.alert-engine.ws.pipelining:true}")
    private boolean pipelining;
    @Value(value="${alerts.alert-engine.ws.tryCompression:true}")
    private boolean tryCompression;
    @Value(value="${alerts.alert-engine.ws.maxPoolSize:50}")
    private int maxPoolSize;
    @Value(value="${alerts.alert-engine.ws.bulkEventsSize:100}")
    private int bulkEventsSize;
    @Value(value="${alerts.alert-engine.ws.bulkEventsWait:100}")
    private int bulkEventsWait;
    @Value(value="${alerts.alert-engine.ws.sendEventsOnHttp:true}")
    private boolean sendEventsOnHttp;
    @Value(value="${httpClient.proxy.type:HTTP}")
    private String proxyType;
    @Value(value="${alerts.alert-engine.ws.useSystemProxy:false}")
    private boolean useSystemProxy;
    @Value(value="${httpClient.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String proxyHttpHost;
    @Value(value="${httpClient.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int proxyHttpPort;
    @Value(value="${httpClient.proxy.http.username:#{null}}")
    private String proxyHttpUsername;
    @Value(value="${httpClient.proxy.http.password:#{null}}")
    private String proxyHttpPassword;
    @Value(value="${httpClient.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String proxyHttpsHost;
    @Value(value="${httpClient.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int proxyHttpsPort;
    @Value(value="${httpClient.proxy.https.username:#{null}}")
    private String proxyHttpsUsername;
    @Value(value="${httpClient.proxy.https.password:#{null}}")
    private String proxyHttpsPassword;
    private Map<String, Engine> engines;

    public ConnectorConfiguration(Environment environment) {
        this.environment = environment;
    }

    public Engine getDefaultEngine() {
        return this.getEngines().get(DEFAULT_ENGINE_NAME);
    }

    private List<String> initializeEndpoints(String key) {
        String fullKey = String.format("%s[%s]", key, 0);
        ArrayList<String> result = new ArrayList<String>();
        while (this.environment.containsProperty(fullKey)) {
            String url = this.environment.getProperty(fullKey);
            result.add(url);
            fullKey = String.format("%s[%s]", key, result.size());
        }
        if (result.isEmpty()) {
            result.add(DEFAULT_ENDPOINT);
        }
        return result;
    }

    private Map<String, Engine> initializeEngines() {
        String keyInitial = "alerts.alert-engine.engines.";
        HashMap<String, Engine> result = new HashMap<String, Engine>();
        HashSet engineNames = new HashSet();
        ((AbstractEnvironment)this.environment).getPropertySources().stream().collect(Collectors.toList()).stream().filter(propertySource -> propertySource instanceof MapPropertySource).forEach(propertySource -> ((Map)((MapPropertySource)propertySource).getSource()).forEach((k, v) -> {
            if (k.startsWith(keyInitial)) {
                String replace = k.replace(keyInitial, "");
                String name = replace.substring(0, replace.indexOf("."));
                engineNames.add(name);
            }
        }));
        engineNames.forEach(name -> {
            String key = String.format("%s%s", keyInitial, name);
            List<Endpoint> endpointList = this.initializeEndpoints(key + ".endpoints").stream().map(Endpoint::new).collect(Collectors.toList());
            String uname = this.environment.getProperty(key + ".security.username");
            String pass = this.environment.getProperty(key + ".security.password");
            result.put((String)name, new Engine(this, endpointList, new Engine.Security(uname, pass)));
        });
        if (!result.isEmpty()) {
            if (result.get(DEFAULT_ENGINE_NAME) == null) {
                throw new RuntimeException("Default engine is not found! You need to have a default engine in your configuration.");
            }
        } else {
            Engine defaultEngine = new Engine(this, this.initializeEndpoints("alerts.alert-engine.ws.endpoints").stream().map(Endpoint::new).collect(Collectors.toList()), new Engine.Security(this.getUsername(), this.getPassword()));
            result.put(DEFAULT_ENGINE_NAME, defaultEngine);
        }
        return result;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public List<String> getKeystorePemCerts() {
        if (this.keystorePemCerts == null) {
            this.keystorePemCerts = this.initializeKeystorePemCerts("alerts.alert-engine.ws.ssl.keystore.certs[%s]");
        }
        return this.keystorePemCerts;
    }

    private List<String> initializeKeystorePemCerts(String property) {
        String key = String.format(property, 0);
        ArrayList<String> values = new ArrayList<String>();
        while (this.environment.containsProperty(key)) {
            values.add(this.environment.getProperty(key));
            key = String.format(property, values.size());
        }
        return values;
    }

    public void setKeystorePemCerts(List<String> keystorePemCerts) {
        this.keystorePemCerts = keystorePemCerts;
    }

    public List<String> getKeystorePemKeys() {
        if (this.keystorePemKeys == null) {
            this.keystorePemKeys = this.initializeKeystorePemCerts("alerts.alert-engine.ws.ssl.keystore.keys[%s]");
        }
        return this.keystorePemKeys;
    }

    public void setKeystorePemKeys(List<String> keystorePemKeys) {
        this.keystorePemKeys = keystorePemKeys;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(boolean hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getBulkEventsSize() {
        return this.bulkEventsSize;
    }

    public void setBulkEventsSize(int bulkEventsSize) {
        this.bulkEventsSize = bulkEventsSize;
    }

    public int getBulkEventsWait() {
        return this.bulkEventsWait;
    }

    public void setBulkEventsWait(int bulkEventsWait) {
        this.bulkEventsWait = bulkEventsWait;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isSendEventsOnHttp() {
        return this.sendEventsOnHttp;
    }

    public void setSendEventsOnHttp(boolean sendEventsOnHttp) {
        this.sendEventsOnHttp = sendEventsOnHttp;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public void setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
    }

    public boolean isTryCompression() {
        return this.tryCompression;
    }

    public void setTryCompression(boolean tryCompression) {
        this.tryCompression = tryCompression;
    }

    public Map<String, Engine> getEngines() {
        if (this.engines == null) {
            this.engines = this.initializeEngines();
        }
        return this.engines;
    }

    public void setEngines(Map<String, Engine> engines) {
        this.engines = engines;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public ConnectorConfiguration setProxyType(String proxyType) {
        this.proxyType = proxyType;
        return this;
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public ConnectorConfiguration setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
        return this;
    }

    public String getProxyHttpHost() {
        return this.proxyHttpHost;
    }

    public ConnectorConfiguration setProxyHttpHost(String proxyHttpHost) {
        this.proxyHttpHost = proxyHttpHost;
        return this;
    }

    public int getProxyHttpPort() {
        return this.proxyHttpPort;
    }

    public ConnectorConfiguration setProxyHttpPort(int proxyHttpPort) {
        this.proxyHttpPort = proxyHttpPort;
        return this;
    }

    public String getProxyHttpUsername() {
        return this.proxyHttpUsername;
    }

    public ConnectorConfiguration setProxyHttpUsername(String proxyHttpUsername) {
        this.proxyHttpUsername = proxyHttpUsername;
        return this;
    }

    public String getProxyHttpPassword() {
        return this.proxyHttpPassword;
    }

    public ConnectorConfiguration setProxyHttpPassword(String proxyHttpPassword) {
        this.proxyHttpPassword = proxyHttpPassword;
        return this;
    }

    public String getProxyHttpsHost() {
        return this.proxyHttpsHost;
    }

    public ConnectorConfiguration setProxyHttpsHost(String proxyHttpsHost) {
        this.proxyHttpsHost = proxyHttpsHost;
        return this;
    }

    public int getProxyHttpsPort() {
        return this.proxyHttpsPort;
    }

    public ConnectorConfiguration setProxyHttpsPort(int proxyHttpsPort) {
        this.proxyHttpsPort = proxyHttpsPort;
        return this;
    }

    public String getProxyHttpsUsername() {
        return this.proxyHttpsUsername;
    }

    public ConnectorConfiguration setProxyHttpsUsername(String proxyHttpsUsername) {
        this.proxyHttpsUsername = proxyHttpsUsername;
        return this;
    }

    public String getProxyHttpsPassword() {
        return this.proxyHttpsPassword;
    }

    public ConnectorConfiguration setProxyHttpsPassword(String proxyHttpsPassword) {
        this.proxyHttpsPassword = proxyHttpsPassword;
        return this;
    }
}

