/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.ws.configuration;

import io.gravitee.ae.connector.ws.Endpoint;
import io.gravitee.ae.connector.ws.configuration.ConnectorConfiguration;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);
    private static final String KEYSTORE_FORMAT_JKS = "JKS";
    private static final String KEYSTORE_FORMAT_PEM = "PEM";
    private static final String KEYSTORE_FORMAT_PKCS12 = "PKCS12";
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    protected final AtomicInteger counter = new AtomicInteger(0);
    private final Map<Endpoint, AtomicInteger> endpointsRetryCount = new HashMap<Endpoint, AtomicInteger>();
    private Endpoint currentEndpoint;
    private ConnectorConfiguration connectorConfiguration;
    private List<Endpoint> endpoints;
    private Security security;

    public Engine() {
    }

    public Engine(ConnectorConfiguration connectorConfiguration, List<Endpoint> endpoints, Security security) {
        this.connectorConfiguration = connectorConfiguration;
        this.endpoints = endpoints;
        this.security = security;
    }

    public HttpClientOptions getHttpClientOptions(Endpoint endpoint) {
        URI target = URI.create(endpoint.getUrl());
        int port = target.getPort() != -1 ? target.getPort() : (HTTPS_SCHEME.equals(target.getScheme()) ? 443 : 80);
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setConnectTimeout(this.connectorConfiguration.getConnectTimeout());
        httpClientOptions.setDefaultPort(port);
        httpClientOptions.setDefaultHost(target.getHost());
        httpClientOptions.setMaxPoolSize(this.connectorConfiguration.getMaxPoolSize());
        httpClientOptions.setIdleTimeout(this.connectorConfiguration.getIdleTimeout());
        httpClientOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        httpClientOptions.setPipelining(this.connectorConfiguration.isPipelining());
        httpClientOptions.setKeepAlive(this.connectorConfiguration.isKeepAlive());
        httpClientOptions.setTryUseCompression(this.connectorConfiguration.isTryCompression());
        if (HTTPS_SCHEME.equalsIgnoreCase(target.getScheme())) {
            httpClientOptions.setSsl(true);
            httpClientOptions.setTrustAll(this.connectorConfiguration.isTrustAll());
            httpClientOptions.setVerifyHost(this.connectorConfiguration.isHostnameVerifier());
            if (this.connectorConfiguration.getKeystoreType() != null) {
                if (this.connectorConfiguration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                    httpClientOptions.setKeyStoreOptions(new JksOptions().setPath(this.connectorConfiguration.getKeystorePath()).setPassword(this.connectorConfiguration.getKeystorePassword()));
                } else if (this.connectorConfiguration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                    httpClientOptions.setPfxKeyCertOptions(new PfxOptions().setPath(this.connectorConfiguration.getKeystorePath()).setPassword(this.connectorConfiguration.getKeystorePassword()));
                } else if (this.connectorConfiguration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PEM)) {
                    httpClientOptions.setPemKeyCertOptions(new PemKeyCertOptions().setCertPaths(this.connectorConfiguration.getKeystorePemCerts()).setKeyPaths(this.connectorConfiguration.getKeystorePemKeys()));
                }
            }
            if (this.connectorConfiguration.getTruststoreType() != null) {
                if (this.connectorConfiguration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                    httpClientOptions.setTrustStoreOptions(new JksOptions().setPath(this.connectorConfiguration.getTruststorePath()).setPassword(this.connectorConfiguration.getTruststorePassword()));
                } else if (this.connectorConfiguration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                    httpClientOptions.setPfxTrustOptions(new PfxOptions().setPath(this.connectorConfiguration.getTruststorePath()).setPassword(this.connectorConfiguration.getTruststorePassword()));
                } else if (this.connectorConfiguration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PEM)) {
                    httpClientOptions.setPemTrustOptions(new PemTrustOptions().addCertPath(this.connectorConfiguration.getTruststorePath()));
                }
            }
        }
        if (this.connectorConfiguration.isUseSystemProxy()) {
            ProxyOptions proxyOptions = new ProxyOptions().setType(ProxyType.valueOf((String)this.connectorConfiguration.getProxyType()));
            if (HTTPS_SCHEME.equals(target.getScheme())) {
                httpClientOptions.setProxyOptions(proxyOptions.setHost(this.connectorConfiguration.getProxyHttpsHost()).setPort(this.connectorConfiguration.getProxyHttpsPort()).setUsername(this.connectorConfiguration.getProxyHttpsUsername()).setPassword(this.connectorConfiguration.getProxyHttpsPassword()));
            } else {
                httpClientOptions.setProxyOptions(proxyOptions.setHost(this.connectorConfiguration.getProxyHttpHost()).setPort(this.connectorConfiguration.getProxyHttpPort()).setUsername(this.connectorConfiguration.getProxyHttpUsername()).setPassword(this.connectorConfiguration.getProxyHttpPassword()));
            }
        }
        return httpClientOptions;
    }

    public Endpoint nextEndpoint() {
        int size = this.endpoints.size();
        if (size == 0) {
            this.currentEndpoint = null;
            return null;
        }
        Endpoint endpoint = this.endpoints.get(Math.abs(this.counter.getAndIncrement() % size));
        this.endpointsRetryCount.computeIfAbsent(endpoint, k -> new AtomicInteger(0));
        int tryConnect = this.endpointsRetryCount.get(endpoint).incrementAndGet();
        if (tryConnect > 5 && endpoint.isRemovable()) {
            logger.info("Alert engine connector tries to connect to instance at {} 5 times. Removing instance...", (Object)endpoint.getUrl());
            this.endpoints.remove(endpoint);
            return this.nextEndpoint();
        }
        this.currentEndpoint = endpoint;
        return endpoint;
    }

    public Endpoint currentEndpoint() {
        return this.currentEndpoint;
    }

    public void resetEndpointRetryCount(Endpoint endpoint) {
        this.endpointsRetryCount.get(endpoint).set(0);
    }

    public Integer getEndpointRetryCount(Endpoint endpoint) {
        return this.endpointsRetryCount.get(endpoint).get();
    }

    public ConnectorConfiguration getConnectorConfiguration() {
        return this.connectorConfiguration;
    }

    public void setConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        this.connectorConfiguration = connectorConfiguration;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security value) {
        this.security = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Engine engine = (Engine)o;
        return Objects.equals(this.endpoints, engine.endpoints) && Objects.equals(this.security, engine.security);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.security);
    }

    public static class Security {
        private String username;
        private String password;

        public Security(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String value) {
            this.username = value;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String value) {
            this.password = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Security security = (Security)o;
            return Objects.equals(this.username, security.username) && Objects.equals(this.password, security.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }
    }
}

