/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.ae.connector.core.probe;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;

public class AlertProbe
implements Probe {
    private AtomicLong droppedEvents = new AtomicLong(0L);
    private boolean healthy = true;
    private boolean ready = false;
    private Throwable lastError;

    public String id() {
        return "alert-engine";
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public CompletionStage<Result> check() {
        Result result = !this.ready ? Result.notReady() : (this.healthy ? Result.healthy((String)"Ok (total dropped events since startup [%s])", (Object[])new Object[]{this.droppedEvents}) : (this.lastError != null ? Result.unhealthy((String)"%s (total dropped events since startup [%s])", (Object[])new Object[]{this.lastError.getMessage(), this.droppedEvents}) : Result.unhealthy((String)"Error (total dropped events since startup [%s])", (Object[])new Object[]{this.droppedEvents})));
        return CompletableFuture.completedFuture(result);
    }

    public void addDroppedEvents(int count) {
        this.droppedEvents.addAndGet(count);
    }

    public void setReady() {
        this.ready = true;
    }

    public void setHealthy() {
        this.healthy = true;
    }

    public void setUnhealthy() {
        this.healthy = false;
    }

    public void setLastError(Throwable throwable) {
        this.lastError = throwable;
    }

    public void setUnhealthy(int count, Throwable throwable) {
        this.addDroppedEvents(count);
        this.setLastError(throwable);
        this.setUnhealthy();
    }
}

