/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.common.util.VertxProxyOptionsUtils;
import io.gravitee.connector.api.AbstractConnector;
import io.gravitee.connector.api.Connection;
import io.gravitee.connector.api.EndpointException;
import io.gravitee.connector.http.AbstractHttpConnection;
import io.gravitee.connector.http.endpoint.HttpClientSslOptions;
import io.gravitee.connector.http.endpoint.HttpEndpoint;
import io.gravitee.connector.http.endpoint.HttpProxy;
import io.gravitee.connector.http.endpoint.ProtocolVersion;
import io.gravitee.connector.http.endpoint.jks.JKSKeyStore;
import io.gravitee.connector.http.endpoint.jks.JKSTrustStore;
import io.gravitee.connector.http.endpoint.pem.PEMKeyStore;
import io.gravitee.connector.http.endpoint.pem.PEMTrustStore;
import io.gravitee.connector.http.endpoint.pkcs12.PKCS12KeyStore;
import io.gravitee.connector.http.endpoint.pkcs12.PKCS12TrustStore;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.node.api.configuration.Configuration;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Base64;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpConnector<E extends HttpEndpoint>
extends AbstractConnector<Connection, ProxyRequest> {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractConnector.class);
    private static final String URI_PARAM_SEPARATOR = "&";
    private static final char URI_PARAM_SEPARATOR_CHAR = '&';
    private static final char URI_PARAM_VALUE_SEPARATOR_CHAR = '=';
    private static final char URI_QUERY_DELIMITER_CHAR = '?';
    private static final CharSequence URI_QUERY_DELIMITER_CHAR_SEQUENCE = "?";
    protected static final int UNSECURE_PORT = 80;
    protected static final int SECURE_PORT = 443;
    protected final E endpoint;
    private final Configuration configuration;
    private HttpClientOptions options;
    private final URLStreamHandler URL_HANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) {
            return null;
        }
    };
    protected final Map<Thread, HttpClient> httpClients = new ConcurrentHashMap<Thread, HttpClient>();
    private final AtomicInteger requestTracker = new AtomicInteger(0);

    public AbstractHttpConnector(E endpoint, Configuration configuration) {
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public void request(ExecutionContext context, ProxyRequest request, Handler<Connection> connectionHandler) {
        String uri = this.appendQueryParameters(request.uri(), (MultiValueMap<String, String>)request.parameters());
        request.metrics().setEndpoint(uri);
        try {
            URL url = new URL(null, uri, this.URL_HANDLER);
            int defaultPort = AbstractHttpConnector.isSecureProtocol(url.getProtocol()) ? 443 : 80;
            int port = url.getPort() != -1 ? url.getPort() : defaultPort;
            String host = port == 80 || port == 443 ? url.getHost() : url.getHost() + ":" + port;
            request.headers().set((CharSequence)"Host", (CharSequence)host);
            if (((HttpEndpoint)((Object)this.endpoint)).getHeaders() != null && !((HttpEndpoint)((Object)this.endpoint)).getHeaders().isEmpty()) {
                ((HttpEndpoint)((Object)this.endpoint)).getHeaders().forEach(header -> request.headers().set((CharSequence)header.getName(), (CharSequence)header.getValue()));
            }
            AbstractHttpConnection<HttpEndpoint> connection = this.create(request);
            HttpClient client = this.httpClients.computeIfAbsent(Thread.currentThread(), this.createHttpClient());
            this.requestTracker.incrementAndGet();
            connection.connect(client, port, url.getHost(), (String)(url.getQuery() == null ? url.getPath() : url.getPath() + "?" + url.getQuery()), (Handler<Void>)((Handler)connect -> connectionHandler.handle((Object)connection)), (Handler<Void>)((Handler)result -> this.requestTracker.decrementAndGet()));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException();
        }
    }

    protected abstract AbstractHttpConnection<HttpEndpoint> create(ProxyRequest var1);

    protected void doStart() throws Exception {
        this.options = this.createHttpClientOptions();
        this.printHttpClientConfiguration();
    }

    private String appendQueryParameters(String uri, MultiValueMap<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            StringJoiner parametersAsString = new StringJoiner(URI_PARAM_SEPARATOR);
            parameters.forEach((paramName, paramValues) -> {
                if (paramValues != null) {
                    for (String paramValue : paramValues) {
                        if (paramValue == null) {
                            parametersAsString.add((CharSequence)paramName);
                            continue;
                        }
                        parametersAsString.add(paramName + "=" + paramValue);
                    }
                }
            });
            if (uri.contains(URI_QUERY_DELIMITER_CHAR_SEQUENCE)) {
                return uri + URI_PARAM_SEPARATOR + parametersAsString.toString();
            }
            return uri + "?" + parametersAsString.toString();
        }
        return uri;
    }

    protected HttpClientOptions createHttpClientOptions() throws EndpointException {
        URL target;
        HttpClientOptions options = new HttpClientOptions();
        options.setPipelining(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isPipelining());
        options.setKeepAlive(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isKeepAlive());
        options.setIdleTimeout((int)(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getIdleTimeout() / 1000L));
        options.setConnectTimeout((int)((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getConnectTimeout());
        options.setMaxPoolSize(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getMaxConcurrentConnections());
        options.setTryUseCompression(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isUseCompression());
        options.setTryUsePerFrameWebSocketCompression(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isUseCompression());
        options.setTryUsePerMessageWebSocketCompression(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isUseCompression());
        options.setWebSocketCompressionAllowClientNoContext(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isUseCompression());
        options.setWebSocketCompressionRequestServerNoContext(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isUseCompression());
        if (((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getVersion() == ProtocolVersion.HTTP_2) {
            options.setProtocolVersion(HttpVersion.HTTP_2);
            options.setHttp2ClearTextUpgrade(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().isClearTextUpgrade());
            options.setHttp2MaxPoolSize(((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getMaxConcurrentConnections());
        }
        try {
            target = new URL(null, this.endpoint.target(), this.URL_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new EndpointException("Endpoint target is not valid " + this.endpoint.target());
        }
        HttpProxy proxy = ((HttpEndpoint)((Object)this.endpoint)).getHttpProxy();
        if (proxy != null && proxy.isEnabled()) {
            if (proxy.isUseSystemProxy()) {
                this.setSystemProxy(options);
            } else {
                ProxyOptions proxyOptions = new ProxyOptions();
                proxyOptions.setHost(proxy.getHost());
                proxyOptions.setPort(proxy.getPort());
                proxyOptions.setUsername(proxy.getUsername());
                proxyOptions.setPassword(proxy.getPassword());
                proxyOptions.setType(ProxyType.valueOf((String)proxy.getType().name()));
                options.setProxyOptions(proxyOptions);
            }
        }
        HttpClientSslOptions sslOptions = ((HttpEndpoint)((Object)this.endpoint)).getHttpClientSslOptions();
        if (AbstractHttpConnector.isSecureProtocol(target.getProtocol())) {
            options.setSsl(true).setUseAlpn(true);
            if (((Boolean)this.configuration.getProperty("http.ssl.openssl", Boolean.class, (Object)false)).booleanValue()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
            if (sslOptions != null) {
                byte[] decode;
                JksOptions jksOptions;
                byte[] decode2;
                PfxOptions pfxOptions;
                options.setVerifyHost(sslOptions.isHostnameVerifier()).setTrustAll(sslOptions.isTrustAll());
                if (!sslOptions.isTrustAll() && sslOptions.getTrustStore() != null) {
                    switch (sslOptions.getTrustStore().getType()) {
                        case PEM: {
                            PEMTrustStore pemTrustStore = (PEMTrustStore)sslOptions.getTrustStore();
                            PemTrustOptions pemTrustOptions = new PemTrustOptions();
                            if (pemTrustStore.getPath() != null && !pemTrustStore.getPath().isEmpty()) {
                                pemTrustOptions.addCertPath(pemTrustStore.getPath());
                            } else if (pemTrustStore.getContent() != null && !pemTrustStore.getContent().isEmpty()) {
                                pemTrustOptions.addCertValue(Buffer.buffer((String)pemTrustStore.getContent()));
                            } else {
                                throw new EndpointException("Missing PEM certificate value for endpoint " + this.endpoint.name());
                            }
                            options.setPemTrustOptions(pemTrustOptions);
                            break;
                        }
                        case PKCS12: {
                            PKCS12TrustStore pkcs12TrustStore = (PKCS12TrustStore)sslOptions.getTrustStore();
                            pfxOptions = new PfxOptions();
                            pfxOptions.setPassword(pkcs12TrustStore.getPassword());
                            if (pkcs12TrustStore.getPath() != null && !pkcs12TrustStore.getPath().isEmpty()) {
                                pfxOptions.setPath(pkcs12TrustStore.getPath());
                            } else if (pkcs12TrustStore.getContent() != null && !pkcs12TrustStore.getContent().isEmpty()) {
                                decode2 = Base64.getDecoder().decode(pkcs12TrustStore.getContent());
                                pfxOptions.setValue(Buffer.buffer((byte[])decode2));
                            } else {
                                throw new EndpointException("Missing PKCS12 value for endpoint " + this.endpoint.name());
                            }
                            options.setPfxTrustOptions(pfxOptions);
                            break;
                        }
                        case JKS: {
                            JKSTrustStore jksTrustStore = (JKSTrustStore)sslOptions.getTrustStore();
                            jksOptions = new JksOptions();
                            jksOptions.setPassword(jksTrustStore.getPassword());
                            if (jksTrustStore.getPath() != null && !jksTrustStore.getPath().isEmpty()) {
                                jksOptions.setPath(jksTrustStore.getPath());
                            } else if (jksTrustStore.getContent() != null && !jksTrustStore.getContent().isEmpty()) {
                                decode = Base64.getDecoder().decode(jksTrustStore.getContent());
                                jksOptions.setValue(Buffer.buffer((byte[])decode));
                            } else {
                                throw new EndpointException("Missing JKS value for endpoint " + this.endpoint.name());
                            }
                            options.setTrustStoreOptions(jksOptions);
                        }
                    }
                }
                if (sslOptions.getKeyStore() != null) {
                    switch (sslOptions.getKeyStore().getType()) {
                        case PEM: {
                            PEMKeyStore pemKeyStore = (PEMKeyStore)sslOptions.getKeyStore();
                            PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
                            if (pemKeyStore.getCertPath() != null && !pemKeyStore.getCertPath().isEmpty()) {
                                pemKeyCertOptions.setCertPath(pemKeyStore.getCertPath());
                            } else if (pemKeyStore.getCertContent() != null && !pemKeyStore.getCertContent().isEmpty()) {
                                pemKeyCertOptions.setCertValue(Buffer.buffer((String)pemKeyStore.getCertContent()));
                            }
                            if (pemKeyStore.getKeyPath() != null && !pemKeyStore.getKeyPath().isEmpty()) {
                                pemKeyCertOptions.setKeyPath(pemKeyStore.getKeyPath());
                            } else if (pemKeyStore.getKeyContent() != null && !pemKeyStore.getKeyContent().isEmpty()) {
                                pemKeyCertOptions.setKeyValue(Buffer.buffer((String)pemKeyStore.getKeyContent()));
                            }
                            options.setPemKeyCertOptions(pemKeyCertOptions);
                            break;
                        }
                        case PKCS12: {
                            PKCS12KeyStore pkcs12KeyStore = (PKCS12KeyStore)sslOptions.getKeyStore();
                            pfxOptions = new PfxOptions();
                            pfxOptions.setPassword(pkcs12KeyStore.getPassword());
                            if (pkcs12KeyStore.getPath() != null && !pkcs12KeyStore.getPath().isEmpty()) {
                                pfxOptions.setPath(pkcs12KeyStore.getPath());
                            } else if (pkcs12KeyStore.getContent() != null && !pkcs12KeyStore.getContent().isEmpty()) {
                                decode2 = Base64.getDecoder().decode(pkcs12KeyStore.getContent());
                                pfxOptions.setValue(Buffer.buffer((byte[])decode2));
                            }
                            options.setPfxKeyCertOptions(pfxOptions);
                            break;
                        }
                        case JKS: {
                            JKSKeyStore jksKeyStore = (JKSKeyStore)sslOptions.getKeyStore();
                            jksOptions = new JksOptions();
                            jksOptions.setPassword(jksKeyStore.getPassword());
                            if (jksKeyStore.getPath() != null && !jksKeyStore.getPath().isEmpty()) {
                                jksOptions.setPath(jksKeyStore.getPath());
                            } else if (jksKeyStore.getContent() != null && !jksKeyStore.getContent().isEmpty()) {
                                decode = Base64.getDecoder().decode(jksKeyStore.getContent());
                                jksOptions.setValue(Buffer.buffer((byte[])decode));
                            }
                            options.setKeyStoreOptions(jksOptions);
                        }
                    }
                }
            }
        }
        return options;
    }

    protected void doStop() throws Exception {
        this.LOGGER.debug("Graceful shutdown of HTTP Client for endpoint[{}] target[{}] requests[{}]", new Object[]{this.endpoint.name(), this.endpoint.target(), this.requestTracker.get()});
        long shouldEndAt = System.currentTimeMillis() + ((HttpEndpoint)((Object)this.endpoint)).getHttpClientOptions().getReadTimeout();
        while (this.requestTracker.get() > 0 && System.currentTimeMillis() <= shouldEndAt) {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (this.requestTracker.get() > 0) {
            this.LOGGER.warn("Cancel requests[{}] for endpoint[{}] target[{}]", new Object[]{this.requestTracker.get(), this.endpoint.name(), this.endpoint.target()});
        }
        this.httpClients.values().forEach(httpClient -> {
            try {
                httpClient.close();
            }
            catch (IllegalStateException ise) {
                this.LOGGER.warn(ise.getMessage());
            }
        });
    }

    private Function<Thread, HttpClient> createHttpClient() {
        return thread -> Vertx.currentContext().owner().createHttpClient(this.options);
    }

    protected static boolean isSecureProtocol(String protocol) {
        return protocol.charAt(protocol.length() - 1) == 's' && protocol.length() > 2;
    }

    private void printHttpClientConfiguration() {
        this.LOGGER.debug("Create HTTP connector with configuration: ");
        this.LOGGER.debug("\t" + this.options.getProtocolVersion() + " {ConnectTimeout='" + this.options.getConnectTimeout() + "', KeepAlive='" + this.options.isKeepAlive() + "', IdleTimeout='" + this.options.getIdleTimeout() + "', MaxChunkSize='" + this.options.getMaxChunkSize() + "', MaxPoolSize='" + this.options.getMaxPoolSize() + "', MaxWaitQueueSize='" + this.options.getMaxWaitQueueSize() + "', Pipelining='" + this.options.isPipelining() + "', PipeliningLimit='" + this.options.getPipeliningLimit() + "', TryUseCompression='" + this.options.isTryUseCompression() + "'}");
        if (this.options.isSsl()) {
            this.LOGGER.debug("\tSSL {TrustAll='" + this.options.isTrustAll() + "', VerifyHost='" + this.options.isVerifyHost() + "'}");
        }
        if (this.options.getProxyOptions() != null) {
            this.LOGGER.debug("\tProxy {Type='" + this.options.getProxyOptions().getType() + ", Host='" + this.options.getProxyOptions().getHost() + "', Port='" + this.options.getProxyOptions().getPort() + "'}");
        }
    }

    private void setSystemProxy(HttpClientOptions options) {
        try {
            VertxProxyOptionsUtils.setSystemProxy((HttpClientOptions)options, (Configuration)this.configuration);
        }
        catch (Exception e) {
            this.LOGGER.warn("A service endpoint (name[{}] type[{}] target[{}]) requires a system proxy to be defined but some configurations are missing or not well defined: {}", new Object[]{this.endpoint.name(), this.endpoint.type(), this.endpoint.target(), e.getMessage()});
            this.LOGGER.warn("Ignoring system proxy");
        }
    }
}

