/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http;

import io.gravitee.connector.api.Connection;
import io.gravitee.connector.api.Response;
import io.gravitee.connector.api.response.ClientConnectionErrorResponse;
import io.gravitee.connector.api.response.ClientConnectionTimeoutResponse;
import io.gravitee.connector.http.AbstractHttpConnection;
import io.gravitee.connector.http.HttpResponse;
import io.gravitee.connector.http.endpoint.HttpEndpoint;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.http2.HttpFrame;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.stream.WriteStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection<T extends HttpResponse>
extends AbstractHttpConnection<HttpEndpoint> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Set<CharSequence> HOP_HEADERS;
    private HttpClientRequest httpClientRequest;
    private final ProxyRequest request;
    private T response;
    private Handler<Throwable> timeoutHandler;
    private boolean canceled = false;
    private boolean transmitted = false;
    private boolean headersWritten = false;
    private boolean content = false;

    public HttpConnection(HttpEndpoint endpoint, ProxyRequest request) {
        super(endpoint);
        this.request = request;
    }

    @Override
    public void connect(HttpClient httpClient, int port, String host, String uri, final Handler<Void> connectionHandler, final Handler<Void> tracker) {
        for (CharSequence header : HOP_HEADERS) {
            this.request.headers().remove((CharSequence)header.toString());
        }
        if (!this.endpoint.getHttpClientOptions().isPropagateClientAcceptEncoding()) {
            this.request.headers().remove((CharSequence)"Accept-Encoding");
        }
        Future<HttpClientRequest> requestFuture = this.prepareUpstreamRequest(httpClient, port, host, uri);
        requestFuture.onComplete((io.vertx.core.Handler)new io.vertx.core.Handler<AsyncResult<HttpClientRequest>>(){

            public void handle(AsyncResult<HttpClientRequest> event) {
                HttpConnection.this.cancelHandler(tracker);
                if (event.succeeded()) {
                    HttpConnection.this.httpClientRequest = (HttpClientRequest)event.result();
                    HttpConnection.this.httpClientRequest.response(response -> HttpConnection.this.handleUpstreamResponse((AsyncResult<HttpClientResponse>)response, (Handler<Void>)tracker));
                    HttpConnection.this.httpClientRequest.connection().exceptionHandler(t -> {
                        HttpConnection.this.LOGGER.debug("Exception occurs during HTTP connection for api [{}] & request id [{}]: {}", new Object[]{HttpConnection.this.request.metrics().getApi(), HttpConnection.this.request.metrics().getRequestId(), t.getMessage()});
                        HttpConnection.this.request.metrics().setMessage(t.getMessage());
                    });
                    HttpConnection.this.httpClientRequest.exceptionHandler(exEvent -> {
                        if (!HttpConnection.this.isCanceled() && !HttpConnection.this.isTransmitted()) {
                            HttpConnection.this.handleException(event.cause());
                            tracker.handle(null);
                        }
                    });
                    connectionHandler.handle(null);
                } else {
                    connectionHandler.handle(null);
                    HttpConnection.this.handleException(event.cause());
                    tracker.handle(null);
                }
            }
        });
    }

    private void handleException(Throwable cause) {
        if (!this.isCanceled() && !this.isTransmitted()) {
            this.request.metrics().setMessage(cause.getMessage());
            if (this.timeoutHandler() != null && (cause instanceof ConnectException || cause instanceof TimeoutException || cause instanceof NoRouteToHostException || cause instanceof UnknownHostException)) {
                this.handleConnectTimeout(cause);
            } else {
                ClientConnectionTimeoutResponse clientResponse = cause instanceof ConnectTimeoutException || cause instanceof TimeoutException ? new ClientConnectionTimeoutResponse() : new ClientConnectionErrorResponse();
                this.sendToClient((Response)clientResponse);
            }
        }
    }

    protected Future<HttpClientRequest> prepareUpstreamRequest(HttpClient httpClient, int port, String host, String uri) {
        return httpClient.request(new RequestOptions().setHost(host).setMethod(HttpMethod.valueOf((String)this.request.method().name())).setPort(Integer.valueOf(port)).setURI(uri).setTimeout(this.endpoint.getHttpClientOptions().getReadTimeout()).setFollowRedirects(Boolean.valueOf(this.endpoint.getHttpClientOptions().isFollowRedirects())));
    }

    protected T createProxyResponse(HttpClientResponse clientResponse) {
        return (T)((Object)new HttpResponse(clientResponse));
    }

    protected T handleUpstreamResponse(AsyncResult<HttpClientResponse> clientResponseFuture, Handler<Void> tracker) {
        if (clientResponseFuture.succeeded()) {
            HttpClientResponse clientResponse = (HttpClientResponse)clientResponseFuture.result();
            this.response = this.createProxyResponse(clientResponse);
            if (this.isSse(this.request)) {
                this.request.closeHandler(proxyConnectionClosed -> {
                    clientResponse.exceptionHandler(null);
                    this.cancel();
                });
            }
            ((HttpResponse)((Object)this.response)).pause();
            this.response.cancelHandler(tracker);
            clientResponse.handler(event -> this.response.bodyHandler().handle((Object)Buffer.buffer((io.vertx.core.buffer.Buffer)event)));
            clientResponse.endHandler(event -> {
                this.response.endHandler().handle(null);
                tracker.handle(null);
            });
            clientResponse.exceptionHandler(throwable -> {
                this.LOGGER.error("Unexpected error while handling backend response for request {} {} - {}", new Object[]{this.httpClientRequest.getMethod(), this.httpClientRequest.absoluteURI(), throwable.getMessage()});
                this.response.endHandler().handle(null);
                tracker.handle(null);
            });
            clientResponse.customFrameHandler(frame -> ((HttpResponse)((Object)((Object)this.response))).writeCustomFrame(HttpFrame.create((int)frame.type(), (int)frame.flags(), (Buffer)Buffer.buffer((io.vertx.core.buffer.Buffer)frame.payload()))));
            this.sendToClient((Response)this.response);
        } else {
            this.handleException(clientResponseFuture.cause());
            tracker.handle(null);
        }
        return this.response;
    }

    public Connection cancel() {
        this.canceled = true;
        this.httpClientRequest.reset();
        this.cancelHandler.handle(null);
        if (this.response != null) {
            this.response.bodyHandler(null);
        }
        return this;
    }

    private boolean isCanceled() {
        return this.canceled;
    }

    private boolean isTransmitted() {
        return this.transmitted;
    }

    public Connection exceptionHandler(Handler<Throwable> timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    @Override
    protected void sendToClient(Response response) {
        this.transmitted = true;
        super.sendToClient(response);
    }

    private void handleConnectTimeout(Throwable throwable) {
        this.timeoutHandler.handle((Object)throwable);
    }

    private Handler<Throwable> timeoutHandler() {
        return this.timeoutHandler;
    }

    public HttpConnection<T> write(Buffer chunk) {
        this.content = true;
        if (!this.headersWritten) {
            this.writeHeaders();
        }
        this.httpClientRequest.write((Object)io.vertx.core.buffer.Buffer.buffer((ByteBuf)chunk.getNativeBuffer()));
        return this;
    }

    public WriteStream<Buffer> drainHandler(Handler<Void> drainHandler) {
        this.httpClientRequest.drainHandler(aVoid -> drainHandler.handle(null));
        return this;
    }

    public boolean writeQueueFull() {
        return this.httpClientRequest.writeQueueFull();
    }

    private void writeHeaders() {
        this.writeUpstreamHeaders();
        this.headersWritten = true;
    }

    protected void writeUpstreamHeaders() {
        io.gravitee.gateway.api.http.HttpHeaders headers = this.request.headers();
        if (this.content) {
            String encoding = headers.getFirst(HttpHeaders.TRANSFER_ENCODING);
            if (encoding != null && encoding.contains("chunked")) {
                this.httpClientRequest.setChunked(true);
            }
        } else {
            this.request.headers().remove(HttpHeaders.TRANSFER_ENCODING);
        }
        this.request.headers().names().forEach(name -> this.httpClientRequest.headers().add(name, (Iterable)this.request.headers().getAll((CharSequence)name)));
    }

    public void end() {
        if (this.httpClientRequest != null) {
            if (!this.headersWritten) {
                this.writeHeaders();
            }
            if (!this.canceled) {
                this.httpClientRequest.end();
            }
        }
    }

    public Connection writeCustomFrame(HttpFrame frame) {
        this.httpClientRequest.writeCustomFrame(frame.type(), frame.flags(), io.vertx.core.buffer.Buffer.buffer((ByteBuf)frame.payload().getNativeBuffer()));
        return this;
    }

    private boolean isSse(ProxyRequest request) {
        return HttpHeaderValues.TEXT_EVENT_STREAM.contentEqualsIgnoreCase((CharSequence)request.headers().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    static {
        HashSet<AsciiString> hopHeaders = new HashSet<AsciiString>();
        hopHeaders.add(HttpHeaderNames.CONNECTION);
        hopHeaders.add(HttpHeaderNames.KEEP_ALIVE);
        hopHeaders.add(HttpHeaderNames.PROXY_AUTHORIZATION);
        hopHeaders.add(HttpHeaderNames.PROXY_AUTHENTICATE);
        hopHeaders.add(HttpHeaderNames.PROXY_CONNECTION);
        hopHeaders.add(HttpHeaderNames.TE);
        hopHeaders.add(HttpHeaderNames.TRAILER);
        hopHeaders.add(HttpHeaderNames.UPGRADE);
        HOP_HEADERS = Collections.unmodifiableSet(hopHeaders);
    }
}

