/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.connector.http.AbstractHttpConnection;
import io.gravitee.connector.http.AbstractHttpConnector;
import io.gravitee.connector.http.HttpConnection;
import io.gravitee.connector.http.endpoint.HttpEndpoint;
import io.gravitee.connector.http.ws.WebSocketConnection;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.node.api.configuration.Configuration;
import io.netty.handler.codec.http.HttpHeaderValues;

public class HttpConnector
extends AbstractHttpConnector<HttpEndpoint> {
    public HttpConnector(HttpEndpoint endpoint, Configuration configuration) {
        super(endpoint, configuration);
    }

    @Override
    protected AbstractHttpConnection<HttpEndpoint> create(ProxyRequest request) {
        String connectionHeader = request.headers().getFirst((CharSequence)"Connection");
        String upgradeHeader = request.headers().getFirst((CharSequence)"Upgrade");
        boolean websocket = request.method() == HttpMethod.GET && HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase((CharSequence)connectionHeader) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)upgradeHeader);
        return websocket ? new WebSocketConnection(this.endpoint, request) : new HttpConnection(this.endpoint, request);
    }
}

