/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http;

import io.gravitee.connector.api.Connection;
import io.gravitee.connector.api.Connector;
import io.gravitee.connector.api.ConnectorBuilder;
import io.gravitee.connector.api.ConnectorContext;
import io.gravitee.connector.api.ConnectorFactory;
import io.gravitee.connector.http.HttpConnector;
import io.gravitee.connector.http.endpoint.HttpEndpoint;
import io.gravitee.connector.http.endpoint.factory.HttpEndpointFactory;
import io.gravitee.connector.http.grpc.GrpcConnector;
import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import java.util.Arrays;
import java.util.Collection;

public class HttpConnectorFactory
implements ConnectorFactory<Connector<Connection, ProxyRequest>> {
    private final HttpEndpointFactory endpointFactory = new HttpEndpointFactory();
    private static final Collection<String> SUPPORTED_TYPES = Arrays.asList("http", "grpc");

    public Collection<String> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    public Connector<Connection, ProxyRequest> create(String target, String configuration, ConnectorBuilder builder) {
        HttpEndpoint httpEndpoint = this.resolve(this.endpointFactory.create(configuration, builder.getMapper()), builder.getContext());
        String type = httpEndpoint.type();
        if (type.equalsIgnoreCase("GRPC")) {
            return new GrpcConnector(httpEndpoint, builder.getConfiguration());
        }
        return new HttpConnector(httpEndpoint, builder.getConfiguration());
    }

    private HttpEndpoint resolve(HttpEndpoint httpEndpoint, ConnectorContext context) {
        TemplateEngine templateEngine = TemplateEngine.templateEngine();
        if (context != null) {
            templateEngine.getTemplateContext().setVariable("properties", (Object)context.getProperties());
        }
        httpEndpoint.target(this.convert(templateEngine, httpEndpoint.target()));
        if (httpEndpoint.getHttpProxy() != null) {
            httpEndpoint.getHttpProxy().setHost(this.convert(templateEngine, httpEndpoint.getHttpProxy().getHost()));
            httpEndpoint.getHttpProxy().setUsername(this.convert(templateEngine, httpEndpoint.getHttpProxy().getUsername()));
            httpEndpoint.getHttpProxy().setPassword(this.convert(templateEngine, httpEndpoint.getHttpProxy().getPassword()));
        }
        if (httpEndpoint.getHeaders() != null && !httpEndpoint.getHeaders().isEmpty()) {
            httpEndpoint.getHeaders().forEach(httpHeader -> httpHeader.setValue(this.convert(templateEngine, httpHeader.getValue())));
        }
        return httpEndpoint;
    }

    private String convert(TemplateEngine templateEngine, String value) {
        if (value != null && !value.isEmpty()) {
            return (String)templateEngine.getValue(value, String.class);
        }
        return value;
    }
}

