/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http.ws;

import io.gravitee.connector.api.Response;
import io.gravitee.connector.api.response.StatusResponse;
import io.gravitee.connector.http.AbstractHttpConnection;
import io.gravitee.connector.http.endpoint.HttpEndpoint;
import io.gravitee.connector.http.ws.SwitchProtocolProxyResponse;
import io.gravitee.connector.http.ws.WebSocketFrame;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.ws.WebSocketProxyRequest;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.api.ws.WebSocketFrame;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WebSocketConnection
extends AbstractHttpConnection<HttpEndpoint> {
    private static final Set<CharSequence> WS_HOP_HEADERS;
    private final WebSocketProxyRequest wsProxyRequest;

    public WebSocketConnection(HttpEndpoint endpoint, ProxyRequest request) {
        super(endpoint);
        this.wsProxyRequest = (WebSocketProxyRequest)request;
    }

    @Override
    public void connect(HttpClient httpClient, int port, String host, String uri, Handler<Void> connectionHandler, Handler<Void> tracker) {
        for (CharSequence header : WS_HOP_HEADERS) {
            this.wsProxyRequest.headers().remove(header);
        }
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(host).setPort(Integer.valueOf(port)).setURI(uri);
        if (this.wsProxyRequest.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL)) {
            this.wsProxyRequest.headers().getAll((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL).forEach(arg_0 -> ((WebSocketConnectOptions)options).addSubProtocol(arg_0));
        }
        this.wsProxyRequest.headers().forEach(entry -> options.addHeader((String)entry.getKey(), (String)entry.getValue()));
        httpClient.webSocket(options, event -> {
            if (event.succeeded()) {
                this.wsProxyRequest.upgrade().thenAccept(webSocketProxyRequest -> {
                    this.wsProxyRequest.frameHandler(frame -> {
                        if (frame.type() == WebSocketFrame.Type.BINARY) {
                            ((WebSocket)event.result()).writeFrame(io.vertx.core.http.WebSocketFrame.binaryFrame((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer((ByteBuf)frame.data().getNativeBuffer()), (boolean)frame.isFinal()));
                        } else if (frame.type() == WebSocketFrame.Type.TEXT) {
                            ((WebSocket)event.result()).writeFrame(io.vertx.core.http.WebSocketFrame.textFrame((String)frame.data().toString(), (boolean)frame.isFinal()));
                        } else if (frame.type() == WebSocketFrame.Type.CONTINUATION) {
                            ((WebSocket)event.result()).writeFrame(io.vertx.core.http.WebSocketFrame.continuationFrame((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer((String)frame.data().toString()), (boolean)frame.isFinal()));
                        } else if (frame.type() == WebSocketFrame.Type.PING) {
                            ((WebSocket)event.result()).writeFrame(io.vertx.core.http.WebSocketFrame.pingFrame((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer((String)frame.data().toString())));
                        } else if (frame.type() == WebSocketFrame.Type.PONG) {
                            ((WebSocket)event.result()).writeFrame(io.vertx.core.http.WebSocketFrame.pongFrame((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer((String)frame.data().toString())));
                        }
                    });
                    this.wsProxyRequest.closeHandler(result -> ((WebSocket)event.result()).close());
                    ((WebSocket)event.result()).frameHandler(frame -> this.wsProxyRequest.write((io.gravitee.gateway.api.ws.WebSocketFrame)new WebSocketFrame((io.vertx.core.http.WebSocketFrame)frame)));
                    ((WebSocket)event.result()).closeHandler(event1 -> {
                        this.wsProxyRequest.close();
                        tracker.handle(null);
                    });
                    ((WebSocket)event.result()).exceptionHandler(throwable -> {
                        this.wsProxyRequest.reject(400);
                        this.sendToClient((Response)new StatusResponse(400));
                        tracker.handle(null);
                    });
                    connectionHandler.handle(null);
                    this.sendToClient(new SwitchProtocolProxyResponse());
                });
            } else {
                connectionHandler.handle(null);
                if (event.cause() instanceof UpgradeRejectedException) {
                    this.wsProxyRequest.reject(((UpgradeRejectedException)event.cause()).getStatus());
                    this.sendToClient((Response)new StatusResponse(((UpgradeRejectedException)event.cause()).getStatus()));
                } else {
                    this.wsProxyRequest.reject(502);
                    this.sendToClient((Response)new StatusResponse(502));
                }
                tracker.handle(null);
            }
        });
    }

    public WriteStream<Buffer> write(Buffer content) {
        return this;
    }

    public void end() {
    }

    static {
        HashSet<AsciiString> wsHopHeaders = new HashSet<AsciiString>();
        wsHopHeaders.add(HttpHeaderNames.KEEP_ALIVE);
        wsHopHeaders.add(HttpHeaderNames.PROXY_AUTHORIZATION);
        wsHopHeaders.add(HttpHeaderNames.PROXY_AUTHENTICATE);
        wsHopHeaders.add(HttpHeaderNames.PROXY_CONNECTION);
        wsHopHeaders.add(HttpHeaderNames.TE);
        wsHopHeaders.add(HttpHeaderNames.TRAILER);
        WS_HOP_HEADERS = Collections.unmodifiableSet(wsHopHeaders);
    }
}

