/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.connector.http;

import io.gravitee.connector.api.Response;
import io.gravitee.connector.api.response.AbstractResponse;
import io.gravitee.connector.http.vertx.VertxHttpHeaders;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.http2.HttpFrame;
import io.gravitee.gateway.api.stream.ReadStream;
import io.vertx.core.http.HttpClientResponse;

public class HttpResponse
extends AbstractResponse {
    private Handler<HttpFrame> frameHandler;
    private final HttpHeaders httpHeaders;
    private final HttpClientResponse httpClientResponse;

    public HttpResponse(HttpClientResponse httpClientResponse) {
        this.httpClientResponse = httpClientResponse;
        this.httpHeaders = new VertxHttpHeaders(this.httpClientResponse.headers());
    }

    public int status() {
        return this.httpClientResponse.statusCode();
    }

    public String reason() {
        return this.httpClientResponse.statusMessage();
    }

    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    public ReadStream<Buffer> pause() {
        this.httpClientResponse.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.httpClientResponse.resume();
        return this;
    }

    public Response customFrameHandler(Handler<HttpFrame> frameHandler) {
        this.frameHandler = frameHandler;
        return this;
    }

    public void writeCustomFrame(HttpFrame frame) {
        if (this.frameHandler != null) {
            this.frameHandler.handle((Object)frame);
        }
    }

    public HttpHeaders trailers() {
        return new VertxHttpHeaders(this.httpClientResponse.trailers());
    }
}

