/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.fetcher.github;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.github.GitHubFetcherConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class GitHubFetcher
implements FilesFetcher {
    private static final Logger logger = LoggerFactory.getLogger(GitHubFetcher.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String VERSION_HEADER = "application/vnd.github.v3+json";
    private GitHubFetcherConfiguration gitHubFetcherConfiguration;
    @Autowired
    private Vertx vertx;
    @Autowired
    private ObjectMapper mapper;
    @Value(value="${httpClient.timeout:10000}")
    private int httpClientTimeout;
    @Value(value="${httpClient.proxy.type:HTTP}")
    private String httpClientProxyType;
    @Value(value="${httpClient.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpHost;
    @Value(value="${httpClient.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpPort;
    @Value(value="${httpClient.proxy.http.username:#{null}}")
    private String httpClientProxyHttpUsername;
    @Value(value="${httpClient.proxy.http.password:#{null}}")
    private String httpClientProxyHttpPassword;
    @Value(value="${httpClient.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpsHost;
    @Value(value="${httpClient.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpsPort;
    @Value(value="${httpClient.proxy.https.username:#{null}}")
    private String httpClientProxyHttpsUsername;
    @Value(value="${httpClient.proxy.https.password:#{null}}")
    private String httpClientProxyHttpsPassword;

    public GitHubFetcher(GitHubFetcherConfiguration cfg) {
        this.gitHubFetcherConfiguration = cfg;
    }

    public FetcherConfiguration getConfiguration() {
        return this.gitHubFetcherConfiguration;
    }

    public Resource fetch() throws FetcherException {
        this.checkRequiredFields(true);
        JsonNode jsonNode = this.request(this.getFetchUrl());
        Resource resource = new Resource();
        if (jsonNode != null) {
            Object htmlUrl;
            Map metadata = (Map)this.mapper.convertValue((Object)jsonNode, Map.class);
            Object content = metadata.remove("content");
            if (content != null) {
                String contentAsBase64 = String.valueOf(content).replaceAll("\\n", "");
                byte[] decodedContent = Base64.getDecoder().decode(contentAsBase64);
                resource.setContent((InputStream)new ByteArrayInputStream(decodedContent));
            }
            if ((htmlUrl = metadata.get("html_url")) != null) {
                metadata.put("edit_url", String.valueOf(htmlUrl).replace("blob", "edit"));
            }
            metadata.put("provider_name", "GitHub");
            resource.setMetadata(metadata);
        }
        return resource;
    }

    public String[] files() throws FetcherException {
        this.checkRequiredFields(false);
        if (this.gitHubFetcherConfiguration.getFilepath() == null || this.gitHubFetcherConfiguration.getFilepath().isEmpty()) {
            this.gitHubFetcherConfiguration.setFilepath("/");
        }
        JsonNode jsonNode = this.request(this.getTreeUrl());
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        if (jsonNode != null) {
            JsonNode truncated = jsonNode.get("truncated");
            if (truncated != null && !truncated.asBoolean(false)) {
                JsonNode rawTree = jsonNode.get("tree");
                if (rawTree != null && rawTree.isArray()) {
                    String filepath = this.gitHubFetcherConfiguration.getFilepath().trim();
                    if (filepath.startsWith("/")) {
                        filepath = filepath.replaceFirst("/", "");
                    }
                    ArrayNode tree = (ArrayNode)rawTree;
                    Iterator elements = tree.elements();
                    while (elements.hasNext()) {
                        int lastIndexOfDot;
                        JsonNode elt = (JsonNode)elements.next();
                        String type = elt.get("type").asText();
                        String path = elt.get("path").asText();
                        if (!"blob".equals(type) || !filepath.isEmpty() && !path.startsWith(filepath) || (lastIndexOfDot = path.lastIndexOf(46)) <= 0) continue;
                        result.add((CallSite)((Object)("/" + path)));
                    }
                }
            } else {
                throw new FetcherException("Too many tree elements to retrieve.", null);
            }
        }
        return result.toArray(new String[0]);
    }

    private void checkRequiredFields(boolean checkFilepath) throws FetcherException {
        if (this.gitHubFetcherConfiguration.getGithubUrl() == null || this.gitHubFetcherConfiguration.getGithubUrl().isEmpty() || this.gitHubFetcherConfiguration.getOwner() == null || this.gitHubFetcherConfiguration.getOwner().isEmpty() || this.gitHubFetcherConfiguration.getRepository() == null || this.gitHubFetcherConfiguration.getRepository().isEmpty() || this.gitHubFetcherConfiguration.isAutoFetch() && (this.gitHubFetcherConfiguration.getFetchCron() == null || this.gitHubFetcherConfiguration.getFetchCron().isEmpty()) || checkFilepath && (this.gitHubFetcherConfiguration.getFilepath() == null || this.gitHubFetcherConfiguration.getFilepath().isEmpty())) {
            throw new FetcherException("Some required configuration attributes are missing.", null);
        }
        if (this.gitHubFetcherConfiguration.isAutoFetch() && this.gitHubFetcherConfiguration.getFetchCron() != null) {
            try {
                new CronSequenceGenerator(this.gitHubFetcherConfiguration.getFetchCron());
            }
            catch (IllegalArgumentException e) {
                throw new FetcherException("Cron expression is invalid", (Throwable)e);
            }
        }
    }

    private String getFetchUrl() {
        return this.gitHubFetcherConfiguration.getGithubUrl() + "/repos/" + this.gitHubFetcherConfiguration.getOwner() + "/" + this.gitHubFetcherConfiguration.getRepository() + "/contents" + this.gitHubFetcherConfiguration.getFilepath() + (String)(this.gitHubFetcherConfiguration.getBranchOrTag() != null && !this.gitHubFetcherConfiguration.getBranchOrTag().isEmpty() ? "?ref=" + this.gitHubFetcherConfiguration.getBranchOrTag() : "");
    }

    private String getTreeUrl() {
        return this.gitHubFetcherConfiguration.getGithubUrl() + "/repos/" + this.gitHubFetcherConfiguration.getOwner() + "/" + this.gitHubFetcherConfiguration.getRepository() + "/git/trees/" + (this.gitHubFetcherConfiguration.getBranchOrTag() != null && !this.gitHubFetcherConfiguration.getBranchOrTag().isEmpty() ? this.gitHubFetcherConfiguration.getBranchOrTag() : "master") + "?recursive=1";
    }

    private JsonNode request(String url) throws FetcherException {
        try {
            Buffer buffer = this.fetchContent(url).join();
            if (buffer == null || buffer.length() == 0) {
                logger.warn("Something goes wrong, GitHub responds with a status 200 but the content is empty.");
                return null;
            }
            return new ObjectMapper().readTree(buffer.getBytes());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new FetcherException("Unable to fetch GitHub content (" + ex.getMessage() + ")", (Throwable)ex);
        }
    }

    private CompletableFuture<Buffer> fetchContent(final String url) throws Exception {
        final Promise promise = Promise.promise();
        URI requestUri = URI.create(url);
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(requestUri.getScheme());
        HttpClientOptions options = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(this.httpClientTimeout);
        if (this.gitHubFetcherConfiguration.isUseSystemProxy()) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setType(ProxyType.valueOf((String)this.httpClientProxyType));
            if (HTTPS_SCHEME.equals(requestUri.getScheme())) {
                proxyOptions.setHost(this.httpClientProxyHttpsHost);
                proxyOptions.setPort(this.httpClientProxyHttpsPort);
                proxyOptions.setUsername(this.httpClientProxyHttpsUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpsPassword);
            } else {
                proxyOptions.setHost(this.httpClientProxyHttpHost);
                proxyOptions.setPort(this.httpClientProxyHttpPort);
                proxyOptions.setUsername(this.httpClientProxyHttpUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpPassword);
            }
            options.setProxyOptions(proxyOptions);
        }
        final HttpClient httpClient = this.vertx.createHttpClient(options);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        try {
            RequestOptions reqOptions = new RequestOptions().setMethod(HttpMethod.GET).setPort(Integer.valueOf(port)).setHost(requestUri.getHost()).setURI(requestUri.toString()).putHeader("User-Agent", this.gitHubFetcherConfiguration.getOwner()).putHeader("X-Gravitee-Request-Id", io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random())).putHeader("Accept", VERSION_HEADER).setTimeout((long)this.httpClientTimeout).setFollowRedirects(Boolean.valueOf(true));
            if (this.gitHubFetcherConfiguration.getUsername() != null && !this.gitHubFetcherConfiguration.getUsername().trim().isEmpty() && this.gitHubFetcherConfiguration.getPersonalAccessToken() != null && !this.gitHubFetcherConfiguration.getPersonalAccessToken().trim().isEmpty()) {
                String auth = this.gitHubFetcherConfiguration.getUsername() + ":" + this.gitHubFetcherConfiguration.getPersonalAccessToken();
                reqOptions.putHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(auth.getBytes()));
            }
            httpClient.request(reqOptions).onFailure((Handler)new Handler<Throwable>(){

                public void handle(Throwable throwable) {
                    promise.fail(throwable);
                    httpClient.close();
                }
            }).onSuccess((Handler)new Handler<HttpClientRequest>(){

                public void handle(HttpClientRequest request) {
                    request.response(asyncResponse -> {
                        if (asyncResponse.failed()) {
                            promise.fail(asyncResponse.cause());
                            httpClient.close();
                        } else {
                            HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                            if (response.statusCode() == 200) {
                                response.bodyHandler(buffer -> {
                                    promise.complete(buffer);
                                    httpClient.close();
                                });
                            } else {
                                promise.fail((Throwable)new FetcherException("Unable to fetch '" + url + "'. Status code: " + response.statusCode() + ". Message: " + response.statusMessage(), null));
                                httpClient.close();
                            }
                        }
                    });
                    request.exceptionHandler(throwable -> {
                        try {
                            promise.fail(throwable);
                            httpClient.close();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    });
                    request.end();
                }
            });
        }
        catch (Exception ex) {
            logger.error("Unable to fetch content using HTTP", (Throwable)ex);
            promise.fail((Throwable)ex);
        }
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }
}

