/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.healthcheck;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckThread;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHealthCheckManagementEndpoint
implements ManagementEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeHealthCheckManagementEndpoint.class);
    private NodeHealthCheckThread registry;
    final ObjectMapper objectMapper = DatabindCodec.prettyMapper();
    public static final String PROBE_FILTER = "probes";

    public NodeHealthCheckManagementEndpoint() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public HttpMethod method() {
        return HttpMethod.GET;
    }

    public String path() {
        return "/health";
    }

    public void handle(RoutingContext ctx) {
        Map<Probe, Result> probes = this.registry.getResults().entrySet().stream().filter(entry -> ctx.queryParams().contains(PROBE_FILTER) ? ctx.queryParams().get(PROBE_FILTER).contains(((Probe)entry.getKey()).id()) : ((Probe)entry.getKey()).isVisibleByDefault()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean healthyProbe = probes.values().stream().allMatch(Result::isHealthy);
        HttpServerResponse response = ctx.response();
        response.setStatusCode(healthyProbe ? 200 : 500);
        response.putHeader("Content-Type", "application/json");
        response.setChunked(true);
        Map<String, Result> results = probes.entrySet().stream().collect(Collectors.toMap(probeResultEntry -> ((Probe)probeResultEntry.getKey()).id(), Map.Entry::getValue));
        try {
            ObjectMapper objectMapper = DatabindCodec.prettyMapper();
            response.write(objectMapper.writeValueAsString(results));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to encode health check result into json.", (Throwable)e);
        }
        response.end();
    }

    public void setRegistry(NodeHealthCheckThread registry) {
        this.registry = registry;
    }
}

