/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.healthcheck.probe;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.node.monitoring.monitor.probe.ProcessProbe;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Value;

public class CPUProbe
implements Probe {
    @Value(value="${services.health.threshold.cpu:80}")
    private int threshold;

    public String id() {
        return "cpu";
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public CompletableFuture<Result> check() {
        try {
            return CompletableFuture.supplyAsync(() -> ProcessProbe.getInstance().getProcessCpuPercent() < this.threshold ? Result.healthy() : Result.unhealthy((String)String.format("CPU percent is over the threshold of %d %%", this.threshold)));
        }
        catch (Exception ex) {
            return CompletableFuture.completedFuture(Result.unhealthy((Throwable)ex));
        }
    }
}

