/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.healthcheck.probe;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.node.monitoring.monitor.probe.JvmProbe;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Value;

public class MemoryProbe
implements Probe {
    @Value(value="${services.health.threshold.memory:80}")
    private int threshold;

    public String id() {
        return "memory";
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public CompletableFuture<Result> check() {
        try {
            return CompletableFuture.supplyAsync(() -> JvmProbe.getInstance().jvmInfo().mem.getHeapUsedPercent() < this.threshold ? Result.healthy() : Result.unhealthy((String)String.format("Memory percent is over the threshold of %d %%", this.threshold)));
        }
        catch (Exception ex) {
            return CompletableFuture.completedFuture(Result.unhealthy((Throwable)ex));
        }
    }
}

