/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.monitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.monitoring.monitor.probe.JvmProbe;
import io.gravitee.node.monitoring.monitor.probe.OsProbe;
import io.gravitee.node.monitoring.monitor.probe.ProcessProbe;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeMonitorManagementEndpoint
implements ManagementEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMonitorManagementEndpoint.class);
    @Autowired
    private ObjectMapper mapper;

    public HttpMethod method() {
        return HttpMethod.GET;
    }

    public String path() {
        return "/monitor";
    }

    public void handle(RoutingContext context) {
        HttpServerResponse response = context.response();
        try {
            ObjectNode root = this.mapper.createObjectNode();
            JsonNode os = this.mapper.valueToTree((Object)OsProbe.getInstance().osInfo());
            JsonNode jvm = this.mapper.valueToTree((Object)JvmProbe.getInstance().jvmInfo());
            JsonNode process = this.mapper.valueToTree((Object)ProcessProbe.getInstance().processInfo());
            root.set("os", os);
            root.set("jvm", jvm);
            root.set("process", process);
            response.putHeader("Content-Type", "application/json");
            response.setChunked(true);
            response.setStatusCode(200);
            response.write(this.mapper.writeValueAsString((Object)root));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unexpected error while generating monitoring", (Throwable)e);
            response.setStatusCode(500);
        }
        response.end();
    }
}

