/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.monitor;

import io.gravitee.alert.api.event.Event;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.monitor.Monitor;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.gravitee.node.monitoring.eventbus.MonitorCodec;
import io.gravitee.node.monitoring.monitor.NodeMonitorManagementEndpoint;
import io.gravitee.node.monitoring.monitor.NodeMonitorThread;
import io.gravitee.plugin.alert.AlertEventProducer;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class NodeMonitorService
extends AbstractService<NodeMonitorService> {
    public static final String GIO_NODE_MONITOR_BUS = "gio:node:monitor";
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMonitorService.class);
    @Value(value="${services.monitoring.enabled:true}")
    private boolean enabled;
    @Value(value="${services.monitoring.delay:5000}")
    private int delay;
    @Value(value="${services.monitoring.unit:MILLISECONDS}")
    private TimeUnit unit;
    private ExecutorService executorService;
    @Autowired
    private NodeMonitorManagementEndpoint nodeMonitorManagementEndpoint;
    @Autowired
    private ManagementEndpointManager managementEndpointManager;
    @Autowired
    private Node node;
    @Autowired
    private AlertEventProducer eventProducer;
    @Autowired
    private Vertx vertx;
    private MessageProducer<Monitor> producer;

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.executorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "node-monitor"));
            this.producer = this.vertx.eventBus().registerCodec((MessageCodec)new MonitorCodec()).sender(GIO_NODE_MONITOR_BUS, new DeliveryOptions().setTracingPolicy(TracingPolicy.IGNORE).setCodecName("gio:bus:codec:node_monitor"));
            NodeMonitorThread monitorThread = new NodeMonitorThread(this.producer);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)monitorThread);
            this.eventProducer.send(Event.now().type("NODE_LIFECYCLE").property("node.event", (Object)"NODE_START").property("node.id", (Object)this.node.id()).property("node.hostname", (Object)this.node.hostname()).property("node.application", (Object)this.node.application()).organizations((Set)this.node.metadata().get("organizations")).environments((Set)this.node.metadata().get("environments")).build());
            LOGGER.info("Node monitoring scheduled with fixed delay {} {} ", (Object)this.delay, (Object)this.unit.name());
            ((ScheduledExecutorService)this.executorService).scheduleWithFixedDelay(monitorThread, 0L, this.delay, this.unit);
            this.managementEndpointManager.register((ManagementEndpoint)this.nodeMonitorManagementEndpoint);
        }
    }

    public NodeMonitorService preStop() throws Exception {
        if (this.enabled) {
            this.eventProducer.send(Event.now().type("NODE_LIFECYCLE").property("node.event", (Object)"NODE_STOP").property("node.id", (Object)this.node.id()).property("node.hostname", (Object)this.node.hostname()).property("node.application", (Object)this.node.application()).organizations((Set)this.node.metadata().get("organizations")).environments((Set)this.node.metadata().get("environments")).build());
        }
        return this;
    }

    protected void doStop() throws Exception {
        if (this.enabled) {
            if (this.executorService != null && !this.executorService.isShutdown()) {
                LOGGER.info("Stop node monitor");
                this.executorService.shutdownNow();
            } else {
                LOGGER.info("Node monitor already shutdown");
            }
            super.doStop();
            LOGGER.info("Stop node monitor : DONE");
        }
    }

    protected String name() {
        return "Node Monitor Service";
    }
}

