/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.monitor.probe;

import io.gravitee.node.api.monitor.JvmInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmProbe {
    private final Logger logger = LoggerFactory.getLogger(JvmProbe.class);
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final String YOUNG = "young";
    private static final String OLD = "old";
    private static final String SURVIVOR = "survivor";

    public static JvmProbe getInstance() {
        return JvmProbeHolder.INSTANCE;
    }

    private JvmProbe() {
    }

    public JvmInfo jvmInfo() {
        JvmInfo info = new JvmInfo(System.currentTimeMillis(), runtimeMXBean.getUptime());
        info.mem = new JvmInfo.Mem();
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        info.mem.heapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        info.mem.heapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        info.mem.heapMax = memUsage.getMax() < 0L ? 0L : memUsage.getMax();
        memUsage = memoryMXBean.getNonHeapMemoryUsage();
        info.mem.nonHeapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        info.mem.nonHeapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<JvmInfo.MemoryPool> pools = new ArrayList<JvmInfo.MemoryPool>();
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            try {
                MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
                MemoryUsage usage = memoryPoolMXBean.getUsage();
                MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
                String name = JvmProbe.getByMemoryPoolName(memoryPoolMXBean.getName(), null);
                if (name == null) continue;
                pools.add(new JvmInfo.MemoryPool(name, usage.getUsed() < 0L ? 0L : usage.getUsed(), usage.getMax() < 0L ? 0L : usage.getMax(), peakUsage.getUsed() < 0L ? 0L : peakUsage.getUsed(), peakUsage.getMax() < 0L ? 0L : peakUsage.getMax()));
                continue;
            }
            catch (OutOfMemoryError err) {
                throw err;
            }
            catch (Exception ex) {
                this.logger.debug("Unexpected exception", (Throwable)ex);
            }
        }
        info.mem.pools = pools.toArray(new JvmInfo.MemoryPool[pools.size()]);
        info.threads = new JvmInfo.Threads();
        info.threads.count = threadMXBean.getThreadCount();
        info.threads.peakCount = threadMXBean.getPeakThreadCount();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        info.gc = new JvmInfo.GarbageCollectors();
        info.gc.collectors = new JvmInfo.GarbageCollector[gcMxBeans.size()];
        for (int i = 0; i < info.gc.collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            info.gc.collectors[i] = new JvmInfo.GarbageCollector();
            info.gc.collectors[i].name = JvmProbe.getByGcName(gcMxBean.getName(), gcMxBean.getName());
            info.gc.collectors[i].collectionCount = gcMxBean.getCollectionCount();
            info.gc.collectors[i].collectionTime = gcMxBean.getCollectionTime();
        }
        return info;
    }

    static String getByMemoryPoolName(String poolName, String defaultName) {
        if ("Eden Space".equals(poolName) || "PS Eden Space".equals(poolName) || "Par Eden Space".equals(poolName) || "G1 Eden Space".equals(poolName)) {
            return YOUNG;
        }
        if ("Survivor Space".equals(poolName) || "PS Survivor Space".equals(poolName) || "Par Survivor Space".equals(poolName) || "G1 Survivor Space".equals(poolName)) {
            return SURVIVOR;
        }
        if ("Tenured Gen".equals(poolName) || "PS Old Gen".equals(poolName) || "CMS Old Gen".equals(poolName) || "G1 Old Gen".equals(poolName)) {
            return OLD;
        }
        return defaultName;
    }

    static String getByGcName(String gcName, String defaultName) {
        if ("Copy".equals(gcName) || "PS Scavenge".equals(gcName) || "ParNew".equals(gcName) || "G1 Young Generation".equals(gcName)) {
            return YOUNG;
        }
        if ("MarkSweepCompact".equals(gcName) || "PS MarkSweep".equals(gcName) || "ConcurrentMarkSweep".equals(gcName) || "G1 Old Generation".equals(gcName)) {
            return OLD;
        }
        return defaultName;
    }

    private static class JvmProbeHolder {
        private static final JvmProbe INSTANCE = new JvmProbe();

        private JvmProbeHolder() {
        }
    }
}

