/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.reporter.vertx;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.reporter.ReporterManager;
import io.gravitee.node.reporter.vertx.eventbus.EventBusReporterWrapper;
import io.gravitee.node.reporter.vertx.verticle.ReporterVerticle;
import io.gravitee.reporter.api.Reporter;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReporterManagerImpl
extends AbstractService<ReporterManager>
implements ReporterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReporterManagerImpl.class);
    @Autowired
    private Vertx vertx;
    private String deploymentId;
    private final Collection<Reporter> reporters = new ArrayList<Reporter>();

    protected void doStart() throws Exception {
        super.doStart();
        this.vertx.deployVerticle("spring:" + ReporterVerticle.class.getName(), event -> {
            if (event.failed()) {
                LOGGER.error("Reporter service can not be started", event.cause());
            } else if (!this.reporters.isEmpty()) {
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.debug("Pre-starting reporter: {}", (Object)reporter);
                        reporter.preStart();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while pre-starting reporter", (Throwable)ex);
                    }
                }
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.info("Starting reporter: {}", (Object)reporter);
                        reporter.start();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while starting reporter", (Throwable)ex);
                    }
                }
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.debug("Port-starting reporter: {}", (Object)reporter);
                        reporter.postStart();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while post-starting reporter", (Throwable)ex);
                    }
                }
            } else {
                LOGGER.info("\tThere is no reporter to start");
            }
            this.deploymentId = (String)event.result();
        });
    }

    @Override
    public void register(Reporter reporter) {
        this.reporters.add(new EventBusReporterWrapper(this.vertx, reporter));
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.deploymentId != null) {
            this.vertx.undeploy(this.deploymentId, event -> {
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.debug("Pre-stopping reporter: {}", (Object)reporter);
                        reporter.preStop();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while pre-stopping reporter", (Throwable)ex);
                    }
                }
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.info("Stopping reporter: {}", (Object)reporter);
                        reporter.stop();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while stopping reporter", (Throwable)ex);
                    }
                }
                for (Reporter reporter : this.reporters) {
                    try {
                        LOGGER.debug("Post-stopping reporter: {}", (Object)reporter);
                        reporter.postStop();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unexpected error while post-stopping reporter", (Throwable)ex);
                    }
                }
            });
        }
    }

    protected String name() {
        return "Reporter service";
    }
}

