/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.reporter.vertx.eventbus;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusReporterWrapper
implements Reporter,
Handler<Message<Reportable>> {
    private final Logger logger = LoggerFactory.getLogger(EventBusReporterWrapper.class);
    private static final String EVENT_BUS_ADDRESS = "node:metrics";
    private final Reporter reporter;
    private final Vertx vertx;

    public EventBusReporterWrapper(Vertx vertx, Reporter reporter) {
        this.vertx = vertx;
        this.reporter = reporter;
    }

    public void report(Reportable reportable) {
    }

    public Lifecycle.State lifecycleState() {
        return this.reporter.lifecycleState();
    }

    public Reporter start() {
        this.vertx.executeBlocking(event -> {
            try {
                this.reporter.start();
                event.complete((Object)this.reporter);
            }
            catch (Exception ex) {
                this.logger.error("Error while starting reporter", (Throwable)ex);
                event.fail((Throwable)ex);
            }
        }, event -> {
            if (event.succeeded()) {
                this.vertx.eventBus().consumer(EVENT_BUS_ADDRESS, (Handler)this);
            }
        });
        return this.reporter;
    }

    public Reporter stop() throws Exception {
        return (Reporter)this.reporter.stop();
    }

    public void handle(Message<Reportable> reportableMsg) {
        Reportable reportable = (Reportable)reportableMsg.body();
        if (this.reporter.canHandle(reportable)) {
            this.reporter.report(reportable);
        }
    }
}

